/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetDyed;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetStairs;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CleaningClothItem;
import net.joefoxe.hexerei.item.custom.WaxBlendItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class WaxingKitItem
extends Item {
    boolean isCreative;

    public WaxingKitItem(Item.Properties pProperties, boolean isCreative) {
        super(pProperties);
        this.isCreative = isCreative;
    }

    public boolean isBarVisible(ItemStack pStack) {
        return true;
    }

    public int getBarColor(ItemStack pStack) {
        CustomData data = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
        if (this.isCreative) {
            return 0xFF55FF;
        }
        if (data != null && data.contains("waxCount") && data.copyTag().getInt("waxCount") > 0) {
            float f = Math.max(0.0f, (float)this.getBarWidth(pStack) / 13.0f);
            return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        }
        return 0x353838;
    }

    public int getBarWidth(ItemStack pStack) {
        CustomData data = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
        if (data != null && data.contains("waxCount") && data.copyTag().getInt("waxCount") > 0) {
            if (data.contains("waxCount")) {
                return (int)((float)data.copyTag().getInt("waxCount") / 256.0f * 13.0f);
            }
            return 0;
        }
        return 13;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        InteractionResult result = InteractionResult.PASS;
        CustomData data = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
        if (this.isCreative || data != null && data.contains("waxCount") && data.copyTag().getInt("waxCount") > 0) {
            result = WaxBlendItem.getWaxed(blockstate).map(newBlockstate -> {
                if (blockstate.hasProperty(ConnectingCarpetDyed.COLOR)) {
                    newBlockstate.setValue(ConnectingCarpetDyed.COLOR, (Comparable)((DyeColor)blockstate.getValue(ConnectingCarpetDyed.COLOR)));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
                }
                if (!this.isCreative) {
                    CompoundTag tag = data.copyTag();
                    tag.putInt("waxCount", tag.getInt("waxCount") - 1);
                    itemstack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
                if (blockstate.getBlock() instanceof CrossCollisionBlock) {
                    BlockState changeTo = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlockstate.setValue((Property)CrossCollisionBlock.NORTH, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.NORTH)))).setValue((Property)CrossCollisionBlock.SOUTH, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.SOUTH)))).setValue((Property)CrossCollisionBlock.EAST, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.EAST)))).setValue((Property)CrossCollisionBlock.WEST, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.WEST)))).setValue((Property)CrossCollisionBlock.WATERLOGGED, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.WATERLOGGED)));
                    if (blockstate.hasProperty(ConnectingCarpetDyed.COLOR)) {
                        changeTo.setValue(ConnectingCarpetDyed.COLOR, (Comparable)((DyeColor)blockstate.getValue(ConnectingCarpetDyed.COLOR)));
                    }
                    level.setBlockAndUpdate(blockpos, changeTo);
                } else {
                    level.setBlock(blockpos, newBlockstate, 11);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
                level.levelEvent(player, 3003, blockpos, 0);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }).orElse(InteractionResult.PASS);
        }
        if (result == InteractionResult.PASS) {
            BlockState cleanedState = CleaningClothItem.getCleanedState(blockstate);
            if (cleanedState != null) {
                level.playSound(player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3004, blockpos, 0);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
                }
                if (blockstate.hasProperty(ConnectingCarpetStairs.COLOR)) {
                    cleanedState = (BlockState)cleanedState.trySetValue(ConnectingCarpetStairs.COLOR, (Comparable)((DyeColor)blockstate.getValue(ConnectingCarpetStairs.COLOR)));
                }
                level.setBlock(blockpos, cleanedState, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)cleanedState));
                if (player != null) {
                    itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        return result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            MutableComponent wax_blend = Component.translatable((String)((Item)ModItems.WAX_BLEND.get()).getDescription().getString()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)7035654)));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.waxing_kit", (Object[])new Object[]{wax_blend}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.waxing_kit_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        int count = 0;
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null && data.contains("waxCount")) {
            count = data.copyTag().getInt("waxCount");
        }
        if (!this.isCreative) {
            tooltipComponents.add((Component)Component.translatable((String)("%s: " + count + " / 256"), (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.wax").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x99AE99)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.infinite_wax").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x99AE99))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

