/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public record BookData(UUID uuid, ResourceLocation book, int chapter, int page, boolean opened, Bookmarks bookmarks, Map<String, PageText> pageTexts) {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    public static final BookData EMPTY = new BookData(EMPTY_UUID, HexereiUtil.getResource("book_of_shadows"), 0, 0, false, new Bookmarks(IntStream.range(0, 20).mapToObj(index -> new Bookmarks.Slot("", DyeColor.WHITE, index)).collect(Collectors.toList())), new HashMap<String, PageText>());
    public static final BookData EMPTY_NOTEBOOK = new BookData(EMPTY_UUID, HexereiUtil.getResource("notebook"), 0, 0, false, new Bookmarks(IntStream.range(0, 20).mapToObj(index -> new Bookmarks.Slot("", DyeColor.WHITE, index)).collect(Collectors.toList())), new HashMap<String, PageText>());
    public static final Function<ResourceLocation, BookData> EMPTY_AS = resourceLoc -> new BookData(EMPTY_UUID, (ResourceLocation)resourceLoc, 0, 0, false, new Bookmarks(IntStream.range(0, 20).mapToObj(index -> new Bookmarks.Slot("", DyeColor.WHITE, index)).collect(Collectors.toList())), (Map<String, PageText>)new HashMap<String, PageText>());
    private static final Codec<Map<String, String>> INNER_MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    public static final Codec<Map<String, Map<String, String>>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, INNER_MAP_CODEC);
    public static final Codec<BookData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("uuid", (Object)EMPTY_UUID).forGetter(BookData::uuid), (App)ResourceLocation.CODEC.fieldOf("book").forGetter(BookData::getBook), (App)Codec.INT.fieldOf("chapter").forGetter(BookData::getChapter), (App)Codec.INT.fieldOf("page").forGetter(BookData::getPage), (App)Codec.BOOL.fieldOf("opened").forGetter(BookData::isOpened), (App)Bookmarks.CODEC.fieldOf("bookmarks").forGetter(BookData::getBookmarks), (App)Codec.unboundedMap((Codec)Codec.STRING, PageText.CODEC).optionalFieldOf("pageTexts", new HashMap()).forGetter(BookData::pageTexts)).apply((Applicative)instance, BookData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BookData> STREAM_CODEC = StreamCodec.of(BookData::toNetwork, BookData::fromNetwork);

    private static BookData fromNetwork(RegistryFriendlyByteBuf buffer) {
        UUID uuid = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)buffer);
        ResourceLocation book = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
        int chapter = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
        int page = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
        boolean opened = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
        Bookmarks bookmarks = (Bookmarks)Bookmarks.STREAM_CODEC.decode((Object)buffer);
        HashMap<String, PageText> pageTexts = new HashMap<String, PageText>();
        int outerSize = buffer.readInt();
        for (int i = 0; i < outerSize; ++i) {
            String outerKey = buffer.readUtf();
            int innerSize = buffer.readInt();
            HashMap<String, String> innerMap = new HashMap<String, String>();
            for (int j = 0; j < innerSize; ++j) {
                String innerKey = buffer.readUtf();
                String innerValue = buffer.readUtf();
                innerMap.put(innerKey, innerValue);
            }
            pageTexts.put(outerKey, new PageText(innerMap));
        }
        return new BookData(uuid, book, chapter, page, opened, bookmarks, pageTexts);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, BookData bookData) {
        UUIDUtil.STREAM_CODEC.encode((Object)buffer, (Object)bookData.uuid);
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)bookData.book);
        ByteBufCodecs.INT.encode((Object)buffer, (Object)bookData.chapter);
        ByteBufCodecs.INT.encode((Object)buffer, (Object)bookData.page);
        ByteBufCodecs.BOOL.encode((Object)buffer, (Object)bookData.opened);
        Bookmarks.STREAM_CODEC.encode((Object)buffer, (Object)bookData.bookmarks);
        buffer.writeInt(bookData.pageTexts.size());
        bookData.pageTexts.forEach((s1, map) -> {
            buffer.writeUtf(s1);
            buffer.writeInt(map.pageTexts.size());
            map.pageTexts.forEach((ss, s) -> {
                buffer.writeUtf(ss);
                buffer.writeUtf(s);
            });
        });
    }

    public BookData updateTextBoxText(String pageId, int textBoxIndex, String text) {
        HashMap<String, PageText> newPageTexts = new HashMap<String, PageText>(this.pageTexts);
        PageText textBoxTexts = newPageTexts.containsKey(pageId) ? new PageText(new HashMap<String, String>(((PageText)newPageTexts.get((Object)pageId)).pageTexts)) : new PageText(new HashMap<String, String>());
        if (textBoxTexts.pageTexts == null) {
            textBoxTexts.pageTexts = new HashMap<String, String>();
        }
        textBoxTexts.pageTexts.put(String.valueOf(textBoxIndex), text);
        newPageTexts.put(pageId, textBoxTexts);
        return new BookData(this.uuid, this.book, this.chapter, this.page, this.opened, this.bookmarks, newPageTexts);
    }

    public String getTextBoxText(String pageId, int textBoxIndex) {
        PageText textBoxTexts = this.pageTexts.get(pageId);
        if (textBoxTexts != null && textBoxTexts.pageTexts.containsKey(String.valueOf(textBoxIndex))) {
            return textBoxTexts.pageTexts.get(String.valueOf(textBoxIndex));
        }
        return "";
    }

    public ResourceLocation getBook() {
        return this.book;
    }

    public int getChapter() {
        return this.chapter;
    }

    public int getPage() {
        return this.page;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BookData setUUID(UUID uuid) {
        return new BookData(uuid, this.book, this.chapter, this.page, this.opened, this.bookmarks, this.pageTexts);
    }

    public BookData setBookmarks(Bookmarks bookmarks) {
        return new BookData(this.uuid, this.book, this.chapter, this.page, this.opened, bookmarks, this.pageTexts);
    }

    public BookData setChapter(int chapter) {
        return new BookData(this.uuid, this.book, chapter, this.page, this.opened, this.bookmarks, this.pageTexts);
    }

    public BookData setPage(int page) {
        return new BookData(this.uuid, this.book, this.chapter, page, this.opened, this.bookmarks, this.pageTexts);
    }

    public BookData setOpened(boolean opened) {
        return new BookData(this.uuid, this.book, this.chapter, this.page, opened, this.bookmarks, this.pageTexts);
    }

    public BookData setBook(ResourceLocation book) {
        return new BookData(this.uuid, book, this.chapter, this.page, this.opened, this.bookmarks, this.pageTexts);
    }

    public static class Bookmarks {
        List<Slot> slots;
        public static final Codec<Bookmarks> CODEC = Slot.CODEC.listOf().xmap(Bookmarks::new, contents -> contents.slots);
        public static final StreamCodec<ByteBuf, Bookmarks> STREAM_CODEC = Slot.STREAM_CODEC.apply(ByteBufCodecs.list()).map(Bookmarks::new, contents -> contents.slots);

        public Bookmarks(List<Slot> slots) {
            this.slots = slots;
        }

        public List<Slot> getSlots() {
            return this.slots;
        }

        public Slot getSlot(int index) {
            return this.slots.get(index);
        }

        public void setSlots(List<Slot> slots) {
            this.slots = slots;
        }

        public void setSlot(int index, Slot slot) {
            this.slots.set(index, slot);
        }

        public static class Slot {
            String id;
            DyeColor color;
            int index;
            public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Slot::getId), (App)DyeColor.CODEC.fieldOf("color").forGetter(Slot::getColor), (App)Codec.INT.fieldOf("index").forGetter(Slot::getIndex)).apply((Applicative)instance, Slot::new));
            public static StreamCodec<ByteBuf, Slot> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

            public Slot(String id, DyeColor color, int index) {
                this.id = id;
                this.color = color;
                this.index = index;
            }

            public String getId() {
                return this.id;
            }

            public DyeColor getColor() {
                return this.color;
            }

            public void setId(String id) {
                this.id = id;
            }

            public void setColor(DyeColor color) {
                this.color = color;
            }

            public int getIndex() {
                return this.index;
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public Slot copy() {
                return new Slot(this.id, this.color, this.index);
            }

            public Slot copyWithIndex(int index) {
                return new Slot(this.id, this.color, index);
            }
        }
    }

    public static class PageText {
        public Map<String, String> pageTexts;
        public static final Codec<PageText> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("text", new HashMap()).forGetter(PageText::getPageTexts)).apply((Applicative)instance, PageText::new));

        public Map<String, String> getPageTexts() {
            return this.pageTexts;
        }

        public PageText(Map<String, String> pageTexts) {
            this.pageTexts = pageTexts;
        }
    }
}

