/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.light;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.joefoxe.hexerei.light.DynamicLightUtil;
import net.joefoxe.hexerei.light.LambHexereiDynamicLight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightManager {
    private static final Set<LambHexereiDynamicLight> dynamicLightSources = new HashSet<LambHexereiDynamicLight>();
    private static final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    public static long lastUpdate = System.currentTimeMillis();
    public static int lastUpdateCount = 0;
    private static final Map<EntityType<?>, List<Function<?, Integer>>> LIGHT_REGISTRY = new HashMap();
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;

    public static void init() {
        LightManager.register(EntityType.FALLING_BLOCK, p -> p.getBlockState().getLightEmission((BlockGetter)p.level(), p.blockPosition()));
        LightManager.register(EntityType.ENDERMAN, enderMan -> {
            if (enderMan.getCarriedBlock() != null) {
                return DynamicLightUtil.fromItemLike((ItemLike)enderMan.getCarriedBlock().getBlock());
            }
            return 0;
        });
        LightManager.register(EntityType.ITEM, p -> DynamicLightUtil.fromItemLike((ItemLike)p.getItem().getItem()));
        LightManager.register((EntityType)ModEntityTypes.BROOM.get(), LightManager::broomLightCheck);
        LightManager.register(EntityType.PLAYER, p -> {
            Entity patt0$temp = p.getVehicle();
            if (patt0$temp instanceof BroomEntity) {
                BroomEntity broom = (BroomEntity)patt0$temp;
                return LightManager.broomLightCheck(broom);
            }
            return 0;
        });
        LightManager.register(EntityType.ITEM_FRAME, p -> DynamicLightUtil.fromItemLike((ItemLike)p.getItem().getItem()));
        LightManager.register(EntityType.GLOW_ITEM_FRAME, p -> Math.max(14, DynamicLightUtil.fromItemLike((ItemLike)p.getItem().getItem())));
        LightManager.register(EntityType.GLOW_SQUID, p -> (int)Mth.clampedLerp((float)0.0f, (float)12.0f, (float)(1.0f - (float)p.getDarkTicksRemaining() / 10.0f)));
    }

    private static int broomLightCheck(BroomEntity broom) {
        BroomBrushItem brushItem;
        Item item = broom.getModule(BroomEntity.BroomSlot.BRUSH).getItem();
        if (item instanceof BroomBrushItem && (brushItem = (BroomBrushItem)item).shouldGlow(broom.level(), broom.getModule(BroomEntity.BroomSlot.BRUSH))) {
            return 15;
        }
        item = broom.getModule(BroomEntity.BroomSlot.MISC).getItem();
        if (item instanceof KeychainItem) {
            KeychainItem keychainItem = (KeychainItem)item;
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            CompoundTag tag = ((CustomData)broom.getModule(BroomEntity.BroomSlot.MISC).getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (!tag.isEmpty()) {
                ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)broom.level().registryAccess());
            }
            return DynamicLightUtil.fromItemLike((ItemLike)((ItemStack)items.get(0)).getItem());
        }
        return 0;
    }

    public static <T extends Entity> void register(EntityType<T> type, Function<T, Integer> luminanceFunction) {
        if (!LIGHT_REGISTRY.containsKey(type)) {
            LIGHT_REGISTRY.put(type, new ArrayList());
        }
        LIGHT_REGISTRY.get(type).add(luminanceFunction);
    }

    public static <T extends Entity> Map<EntityType<?>, List<Function<?, Integer>>> getLightRegistry() {
        return LIGHT_REGISTRY;
    }

    public static <T extends Entity> int getValue(T entity) {
        int val = 0;
        if (!LIGHT_REGISTRY.containsKey(entity.getType())) {
            return val;
        }
        EntityType type = entity.getType();
        for (Function<?, Integer> function : LIGHT_REGISTRY.get(type)) {
            Function<?, Integer> fun = function;
            Integer value = fun.apply(entity);
            if (value <= val) continue;
            val = value;
        }
        return val;
    }

    public static boolean containsEntity(EntityType<? extends Entity> type) {
        return LIGHT_REGISTRY.containsKey(type) || HexConfig.ENTITY_LIGHT_MAP.containsKey(BuiltInRegistries.ENTITY_TYPE.getKey(type));
    }

    public static void addLightSource(LambHexereiDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorldH().isClientSide()) {
            return;
        }
        if (!LightManager.shouldUpdateDynamicLight()) {
            return;
        }
        if (LightManager.containsLightSource(lightSource)) {
            return;
        }
        lightSourcesLock.writeLock().lock();
        dynamicLightSources.add(lightSource);
        lightSourcesLock.writeLock().unlock();
    }

    public static boolean containsLightSource(@NotNull LambHexereiDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorldH().isClientSide()) {
            return false;
        }
        lightSourcesLock.readLock().lock();
        boolean result = dynamicLightSources.contains(lightSource);
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        lightSourcesLock.readLock().lock();
        int result = dynamicLightSources.size();
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static void removeLightSource(LambHexereiDynamicLight lightSource) {
        lightSourcesLock.writeLock().lock();
        Iterator<LambHexereiDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambHexereiDynamicLight it = sourceIterator.next();
            if (!it.equals(lightSource)) continue;
            sourceIterator.remove();
            if (Minecraft.getInstance().level == null) break;
            lightSource.lambdynlights$scheduleTrackedChunksRebuildH(Minecraft.getInstance().levelRenderer);
            break;
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void clearLightSources() {
        lightSourcesLock.writeLock().lock();
        Iterator<LambHexereiDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambHexereiDynamicLight it = sourceIterator.next();
            sourceIterator.remove();
            if (Minecraft.getInstance().levelRenderer == null) continue;
            if (it.getLuminanceH() > 0) {
                it.resetDynamicLightH();
            }
            it.lambdynlights$scheduleTrackedChunksRebuildH(Minecraft.getInstance().levelRenderer);
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, BlockPos.getX((long)chunkPos), BlockPos.getY((long)chunkPos), BlockPos.getZ((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.getInstance().level != null) {
            renderer.setSectionDirty(x, y, z);
        }
    }

    public static void updateAll(LevelRenderer renderer) {
        long now;
        lastUpdate = now = System.currentTimeMillis();
        lastUpdateCount = 0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            if (!lightSource.lambdynlights$updateDynamicLightH(renderer)) continue;
            ++lastUpdateCount;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.asLong();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return LightManager.getLightmapWithDynamicLight(LightManager.getDynamicLightLevelWorld(pos), lightmap);
    }

    public static int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightManager.getBlockLightNoPatch(lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static int getBlockLightNoPatch(int light) {
        return light >> 4 & 0xFFFF;
    }

    public static double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.clamp((double)result, (double)0.0, (double)15.0);
    }

    public static double getDynamicLightLevelWorld(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.clamp((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull LambHexereiDynamicLight lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.getLuminanceH();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.getX() - lightSource.getDynamicLightXH() + 0.5) * dx + (dy = (double)pos.getY() - lightSource.getDynamicLightYH() + 0.5) * dy + (dz = (double)pos.getZ() - lightSource.getDynamicLightZH() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static void updateLightTracking(@NotNull LambHexereiDynamicLight lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabledH();
        int luminance = lightSource.getLuminanceH();
        if (!enabled && luminance > 0) {
            lightSource.setHexereiDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setHexereiDynamicLightEnabled(false);
        }
    }

    public static boolean shouldUpdateDynamicLight() {
        return (Boolean)HexConfig.DYNAMIC_LIGHT_TOGGLE.get();
    }

    public static void toggleLightsAndConfig(boolean enabled) {
        if (ModList.get().isLoaded("ars_nouveau")) {
            enabled = false;
        }
        HexConfig.DYNAMIC_LIGHT_TOGGLE.set((Object)enabled);
        HexConfig.DYNAMIC_LIGHT_TOGGLE.save();
        if (!enabled) {
            LightManager.clearLightSources();
        }
    }
}

