/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ScreenEffectRenderer.class})
public abstract class ScreenEffectRendererMixin {
    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"renderScreenEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderScreenEffect(Minecraft pMinecraft, PoseStack pPoseStack, CallbackInfo ci) {
        LocalPlayer player = pMinecraft.player;
        Camera camera = pMinecraft.gameRenderer.getMainCamera();
        double d0 = camera.getPosition().y() - 0.1111111119389534;
        BlockPos blockpos = new BlockPos((int)camera.getPosition().x(), (int)d0, (int)camera.getPosition().z());
        BlockEntity blockEntity = player.level().getBlockEntity(blockpos);
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile tile = (MixingCauldronTile)blockEntity;
            if (tile.renderedFluid != null) {
                double d1 = (float)blockpos.getY() + (float)tile.renderedFluid.getAmount() / 2000.0f;
                if (d1 > d0 && !tile.renderedFluid.getFluid().isSame((Fluid)Fluids.WATER)) {
                    IClientFluidTypeExtensions.of((Fluid)tile.renderedFluid.getFluid()).renderOverlay(pMinecraft, pPoseStack);
                }
                ci.cancel();
            }
        }
    }
}

