/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.joefoxe.hexerei.block.custom.ModChest;
import net.joefoxe.hexerei.tileentity.ModChestBlockEntity;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean xmasTextures;
    public static final ResourceLocation WILLOW_CHEST_LOCATION = HexereiUtil.getResource("textures/entity/chest/willow.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION = HexereiUtil.getResource("textures/entity/chest/witch_hazel.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION = HexereiUtil.getResource("textures/entity/chest/mahogany.png");
    public static final ResourceLocation HOOTY_LOCATION = HexereiUtil.getResource("textures/entity/chest/hooty.png");
    public static final ResourceLocation HOOTLE_LOCATION = HexereiUtil.getResource("textures/entity/chest/hootle.png");
    public static final ResourceLocation WILLOW_CHEST_LOCATION_LEFT = HexereiUtil.getResource("textures/entity/chest/willow_left.png");
    public static final ResourceLocation WILLOW_CHEST_LOCATION_RIGHT = HexereiUtil.getResource("textures/entity/chest/willow_right.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION_LEFT = HexereiUtil.getResource("textures/entity/chest/witch_hazel_left.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION_RIGHT = HexereiUtil.getResource("textures/entity/chest/witch_hazel_right.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION_LEFT = HexereiUtil.getResource("textures/entity/chest/mahogany_left.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION_RIGHT = HexereiUtil.getResource("textures/entity/chest/mahogany_right.png");

    public ModChestRenderer(BlockEntityRendererProvider.Context pContext) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = pContext.bakeLayer(new ModelLayerLocation(HexereiUtil.getResource("chest/mahogany"), "main"));
        this.bottom = modelpart.getChild(BOTTOM);
        this.lid = modelpart.getChild(LID);
        this.lock = modelpart.getChild(LOCK);
        ModelPart modelpart1 = pContext.bakeLayer(new ModelLayerLocation(HexereiUtil.getResource("chest/mahogany_left"), "main"));
        this.doubleLeftBottom = modelpart1.getChild(BOTTOM);
        this.doubleLeftLid = modelpart1.getChild(LID);
        this.doubleLeftLock = modelpart1.getChild(LOCK);
        ModelPart modelpart2 = pContext.bakeLayer(new ModelLayerLocation(HexereiUtil.getResource("chest/mahogany_right"), "main"));
        this.doubleRightBottom = modelpart2.getChild(BOTTOM);
        this.doubleRightLid = modelpart2.getChild(LID);
        this.doubleRightLock = modelpart2.getChild(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.getLevel();
        boolean flag = level != null;
        BlockState blockstate = flag ? pBlockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockstate.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            pPoseStack.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            pPoseStack.translate(0.5, 0.5, 0.5);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(-f));
            pPoseStack.translate(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.combine(blockstate, level, pBlockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)pBlockEntity)))).get(pPartialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            VertexConsumer vertexConsumer = pBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getLoc(chesttype, (BlockEntity)pBlockEntity)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(pPoseStack, vertexConsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, pPackedOverlay);
                } else {
                    this.render(pPoseStack, vertexConsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, pPackedOverlay);
                }
            } else {
                this.render(pPoseStack, vertexConsumer, this.lid, this.lock, this.bottom, f1, i, pPackedOverlay);
            }
            pPoseStack.popPose();
        }
    }

    private void render(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, ModelPart pBottomPart, float pLidAngle, int pPackedLight, int pPackedOverlay) {
        pLockPart.xRot = pLidPart.xRot = -(pLidAngle * 1.5707964f);
        pLidPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottomPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    protected ResourceLocation getLoc(ChestType chestType, BlockEntity block) {
        if (block instanceof ModChestBlockEntity) {
            ModChestBlockEntity blockEntity = (ModChestBlockEntity)block;
            if (blockEntity.hasCustomName() && blockEntity.getCustomName().getString().equals("Hootle") && chestType == ChestType.SINGLE) {
                return HOOTLE_LOCATION;
            }
            if (blockEntity.hasCustomName() && blockEntity.getCustomName().getString().equals("Hooty") && chestType == ChestType.SINGLE) {
                return HOOTY_LOCATION;
            }
        }
        ModChest.WoodType style = ModChest.WoodType.WILLOW;
        if (block.getBlockState().hasProperty(ModChest.WOOD_TYPE)) {
            style = (ModChest.WoodType)((Object)block.getBlockState().getValue(ModChest.WOOD_TYPE));
        }
        ResourceLocation left = this.getLeft(style);
        ResourceLocation right = this.getRight(style);
        ResourceLocation single = this.getSingle(style);
        return ModChestRenderer.chooseLoc(chestType, single, left, right);
    }

    public ResourceLocation getLeft(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION_LEFT;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION_LEFT;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION_LEFT;
        };
    }

    public ResourceLocation getRight(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION_RIGHT;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION_RIGHT;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION_RIGHT;
        };
    }

    public ResourceLocation getSingle(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION;
        };
    }

    public static ResourceLocation chooseLoc(ChestType pChestType, ResourceLocation pDoubleMaterial, ResourceLocation pLeftMaterial, ResourceLocation pRightMaterial) {
        return switch (pChestType) {
            case ChestType.LEFT -> pLeftMaterial;
            case ChestType.RIGHT -> pRightMaterial;
            default -> pDoubleMaterial;
        };
    }
}

