/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CandleExtinguishPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CandleExtinguishPacket> CODEC = StreamCodec.ofMember(CandleExtinguishPacket::encode, CandleExtinguishPacket::new);
    public static final CustomPacketPayload.Type<CandleExtinguishPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("candle_extinguish"));
    BlockPos pos;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CandleExtinguishPacket(BlockPos pos) {
        this.pos = pos;
    }

    public CandleExtinguishPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public static CandleExtinguishPacket decode(FriendlyByteBuf buffer) {
        return new CandleExtinguishPacket(buffer.readBlockPos());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity;
        if (player.level().getBlockEntity(this.pos) != null && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)blockEntity;
            Candle.extinguish((LevelAccessor)player.level(), this.pos, player.level().getBlockState(this.pos), candleTile);
        }
    }
}

