/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientboundBookTurnPage
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundBookTurnPage> CODEC = StreamCodec.ofMember(ClientboundBookTurnPage::encode, ClientboundBookTurnPage::new);
    public static final CustomPacketPayload.Type<ClientboundBookTurnPage> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("book_turn_page_client"));
    BlockPos bookAltar;
    int turnPage;
    int turnToChapter;
    int turnToPage;
    int chapter;
    int page;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientboundBookTurnPage(BookOfShadowsAltarTile bookAltar, int turnPage, int turnToChapter, int turnToPage, int chapter, int page) {
        this.bookAltar = bookAltar.getBlockPos();
        this.turnPage = turnPage;
        this.turnToChapter = turnToChapter;
        this.turnToPage = turnToPage;
        this.chapter = chapter;
        this.page = page;
    }

    public ClientboundBookTurnPage(RegistryFriendlyByteBuf buf) {
        this.bookAltar = buf.readBlockPos();
        this.turnPage = buf.readInt();
        this.turnToChapter = buf.readInt();
        this.turnToPage = buf.readInt();
        this.chapter = buf.readInt();
        this.page = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.bookAltar);
        buffer.writeInt(this.turnPage);
        buffer.writeInt(this.turnToChapter);
        buffer.writeInt(this.turnToPage);
        buffer.writeInt(this.chapter);
        buffer.writeInt(this.page);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.bookAltar);
        if (blockEntity instanceof BookOfShadowsAltarTile) {
            BookOfShadowsAltarTile book = (BookOfShadowsAltarTile)blockEntity;
            if (this.turnPage == -2) {
                this.turnPage += 2;
            }
            book.turnPage = this.turnPage;
            book.turnToChapter = this.turnToChapter;
            book.turnToPage = this.turnToPage;
            book.currentBook = book.currentBook.setChapter(this.chapter);
            book.currentBook = book.currentBook.setPage(this.page);
            book.pageOneRotationRender = 0.0f;
            book.pageOneRotation = 0.0f;
            book.pageOneRotationTo = 0.0f;
            book.pageOneRotationLast = book.pageOneRotation;
            book.pageTwoRotationRender = 0.0f;
            book.pageTwoRotation = 0.0f;
            book.pageTwoRotationTo = 0.0f;
            book.pageTwoRotationLast = book.pageTwoRotation;
        }
    }
}

