/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.item.custom.CofferItem;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CofferInvUpdateWhitelistToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CofferInvUpdateWhitelistToServer> CODEC = StreamCodec.ofMember(CofferInvUpdateWhitelistToServer::encode, CofferInvUpdateWhitelistToServer::new);
    public static final CustomPacketPayload.Type<CofferInvUpdateWhitelistToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("coffer_inv_update_whitelist_slot"));
    int slotIndex;
    ItemStack stack;
    int slot;
    boolean remove;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CofferInvUpdateWhitelistToServer(int slotIndex, int slot, ItemStack stack) {
        this.slotIndex = slotIndex;
        this.stack = stack;
        this.slot = slot;
        this.remove = stack.isEmpty();
    }

    public CofferInvUpdateWhitelistToServer(RegistryFriendlyByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.slot = buf.readInt();
        this.remove = buf.readBoolean();
        this.stack = this.remove ? ItemStack.EMPTY : (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.slotIndex);
        buffer.writeInt(this.slot);
        buffer.writeBoolean(this.remove);
        if (!this.remove) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.stack);
        }
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        if (player != null) {
            if (Inventory.isHotbarSlot((int)this.slotIndex)) {
                ItemStack handStack;
                if (this.slotIndex == player.getInventory().selected && (handStack = player.getMainHandItem()).getItem() instanceof CofferItem) {
                    NonNullList whitelist = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
                    CompoundTag tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    if (tag.contains("WhitelistItems", 9)) {
                        ListTag itemsTag = tag.getList("WhitelistItems", 10);
                        for (int i = 0; i < itemsTag.size(); ++i) {
                            CompoundTag slotTag = itemsTag.getCompound(i);
                            int slot = slotTag.getInt("Slot");
                            if (slot < 0 || slot >= whitelist.size()) continue;
                            whitelist.set(slot, (Object)ItemStack.parse((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)slotTag.getCompound("Item")).orElse(ItemStack.EMPTY));
                        }
                    }
                    if (whitelist.stream().noneMatch(stack1 -> ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack1)) || this.stack.isEmpty()) {
                        int writeIndex = 0;
                        for (int readIndex = 0; readIndex < whitelist.size(); ++readIndex) {
                            if (((ItemStack)whitelist.get(readIndex)).isEmpty()) continue;
                            if (readIndex != writeIndex) {
                                whitelist.set(writeIndex, (Object)((ItemStack)whitelist.get(readIndex)).copy());
                                whitelist.set(readIndex, (Object)ItemStack.EMPTY);
                            }
                            ++writeIndex;
                        }
                        whitelist.set(this.stack.isEmpty() ? this.slot : writeIndex, (Object)this.stack);
                        ListTag itemsTag = new ListTag();
                        for (int slot = 0; slot < whitelist.size(); ++slot) {
                            ItemStack stack = (ItemStack)whitelist.get(slot);
                            if (stack.isEmpty()) continue;
                            CompoundTag slotTag = new CompoundTag();
                            slotTag.putInt("Slot", slot);
                            Tag itemTag = stack.save((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)slotTag);
                            slotTag.put("Item", itemTag);
                            itemsTag.add((Object)slotTag);
                        }
                        tag.put("WhitelistItems", (Tag)itemsTag);
                        handStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    }
                }
            } else {
                ItemStack handStack = player.getOffhandItem();
                if (handStack.getItem() instanceof CofferItem) {
                    NonNullList whitelist = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
                    CompoundTag tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    if (tag.contains("WhitelistItems", 9)) {
                        ListTag itemsTag = tag.getList("WhitelistItems", 10);
                        for (int i = 0; i < itemsTag.size(); ++i) {
                            CompoundTag slotTag = itemsTag.getCompound(i);
                            int slot = slotTag.getInt("Slot");
                            if (slot < 0 || slot >= whitelist.size()) continue;
                            whitelist.set(slot, (Object)ItemStack.parse((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)slotTag.getCompound("Item")).orElse(ItemStack.EMPTY));
                        }
                    }
                    if (whitelist.stream().noneMatch(stack1 -> ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack1)) || this.stack.isEmpty()) {
                        int writeIndex = 0;
                        for (int readIndex = 0; readIndex < whitelist.size(); ++readIndex) {
                            if (((ItemStack)whitelist.get(readIndex)).isEmpty()) continue;
                            if (readIndex != writeIndex) {
                                whitelist.set(writeIndex, (Object)((ItemStack)whitelist.get(readIndex)).copy());
                                whitelist.set(readIndex, (Object)ItemStack.EMPTY);
                            }
                            ++writeIndex;
                        }
                        whitelist.set(this.stack.isEmpty() ? this.slot : writeIndex, (Object)this.stack);
                        ListTag itemsTag = new ListTag();
                        for (int slot = 0; slot < whitelist.size(); ++slot) {
                            ItemStack stack = (ItemStack)whitelist.get(slot);
                            if (stack.isEmpty()) continue;
                            CompoundTag slotTag = new CompoundTag();
                            slotTag.putInt("Slot", slot);
                            Tag itemTag = stack.save((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)slotTag);
                            slotTag.put("Item", itemTag);
                            itemsTag.add((Object)slotTag);
                        }
                        tag.put("WhitelistItems", (Tag)itemsTag);
                        handStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    }
                }
            }
        }
    }
}

