/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.joefoxe.hexerei.data.coffer.ClientCofferData;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SyncCofferInventoryPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCofferInventoryPacket> CODEC = StreamCodec.ofMember(SyncCofferInventoryPacket::encode, SyncCofferInventoryPacket::new);
    public static final CustomPacketPayload.Type<SyncCofferInventoryPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("sync_coffer_inv_client"));
    private final UUID cofferId;
    private final Map<Integer, ItemStack> slotToItemMap;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public SyncCofferInventoryPacket(UUID cofferId, NonNullList<ItemStack> items) {
        this.cofferId = cofferId;
        this.slotToItemMap = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            this.slotToItemMap.put(i, stack);
        }
    }

    public SyncCofferInventoryPacket(RegistryFriendlyByteBuf buf) {
        this.cofferId = buf.readUUID();
        this.slotToItemMap = new HashMap<Integer, ItemStack>();
        int numNonEmptyStacks = buf.readVarInt();
        for (int i = 0; i < numNonEmptyStacks; ++i) {
            int slot = buf.readVarInt();
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            this.slotToItemMap.put(slot, stack);
        }
    }

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.cofferId);
        buf.writeVarInt(this.slotToItemMap.size());
        this.slotToItemMap.forEach((slot, stack) -> {
            buf.writeVarInt(slot.intValue());
            ItemStack.STREAM_CODEC.encode((Object)buf, stack);
        });
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        NonNullList items = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        this.slotToItemMap.forEach((arg_0, arg_1) -> ((NonNullList)items).set(arg_0, arg_1));
        ClientCofferData.storeInventory(this.cofferId, (NonNullList<ItemStack>)items);
    }
}

