/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.biome;

import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.world.gen.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class ModBiomes {
    public static final ResourceKey<Biome> WILLOW_SWAMP = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)HexereiUtil.getResource("willow_swamp"));

    public static void bootstrap(BootstrapContext<Biome> context) {
    }

    private static Biome makeWillowSwampBiome(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder mobSpawnSettingsBuilder = new MobSpawnSettings.Builder();
        HolderGetter placedFeature = context.lookup(Registries.PLACED_FEATURE);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        mobSpawnSettingsBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 1, 1, 1));
        mobSpawnSettingsBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FROG, 10, 2, 5));
        BiomeGenerationSettings.Builder genSettingsBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)genSettingsBuilder);
        ModBiomes.globalOverworldGeneration(genSettingsBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_SWAMP);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_NORMAL);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_WATERLILY);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.BROWN_MUSHROOM_SWAMP);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.RED_MUSHROOM_SWAMP);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        BiomeDefaultFeatures.addJungleVines((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.LUSH_CAVES_CEILING_VEGETATION);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CAVE_VINES);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.ROOTED_AZALEA_TREE);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.SPORE_BLOSSOM);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CLASSIC_VINES);
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeature.getOrThrow(ModPlacedFeatures.FLOWERING_LILYPAD_PLACED_KEY));
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeature.getOrThrow(ModPlacedFeatures.SWAMP_FLOWERS_PLACED_KEY));
        genSettingsBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeature.getOrThrow(ModPlacedFeatures.TREES_WILLOW_SWAMP_PLACED_KEY));
        BiomeSpecialEffects.Builder specialEffectsBuilder = new BiomeSpecialEffects.Builder();
        specialEffectsBuilder.waterColor(6388580).waterFogColor(2302743).fogColor(12638463).skyColor(ModBiomes.getSkyColorWithTemperatureModifier(0.8f)).foliageColorOverride(6975545).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(specialEffectsBuilder.build()).mobSpawnSettings(mobSpawnSettingsBuilder.build()).generationSettings(genSettingsBuilder.build()).build();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = Mth.clamp((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)builder);
    }
}

