/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.ConnectedPillarBlock;
import net.joefoxe.hexerei.block.connected.LayeredBlock;
import net.joefoxe.hexerei.world.structure.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class NatureCovenStructure
extends Structure {
    public static final MapCodec<NatureCovenStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NatureCovenStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, NatureCovenStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    static final Logger LOGGER = LogUtils.getLogger();

    public NatureCovenStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.chunkPos();
        return context.chunkGenerator().getFirstOccupiedHeight(chunkpos.getMinBlockX(), chunkpos.getMinBlockZ(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.heightAccessor(), context.randomState()) < 150;
    }

    private boolean canBeReplaced(BlockState currBlock) {
        return currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.MUD_BRICK_SLAB) || currBlock.is(Blocks.MOSS_CARPET) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_FENCE.get()) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_SLAB.get()) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_STAIRS.get()) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA);
    }

    public void afterPlace(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, RandomSource pRandom, BoundingBox pBoundingBox, ChunkPos pChunkPos, PiecesContainer pPieces) {
        super.afterPlace(pLevel, pStructureManager, pChunkGenerator, pRandom, pBoundingBox, pChunkPos, pPieces);
        try {
            block2: for (BlockPos blockPos : BlockPos.betweenClosed((int)pBoundingBox.minX(), (int)pBoundingBox.minY(), (int)pBoundingBox.minZ(), (int)pBoundingBox.maxX(), (int)pBoundingBox.maxY(), (int)pBoundingBox.maxZ())) {
                int itor;
                BlockState currBlock;
                BlockPos.MutableBlockPos mutable;
                if (!pPieces.isInsidePiece(blockPos) || !pLevel.isAreaLoaded(blockPos, 1) || !pLevel.getBlockState(blockPos).is(Blocks.YELLOW_STAINED_GLASS_PANE)) continue;
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    serverLevel.setBlockAndUpdate(blockPos, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).defaultBlockState());
                    mutable = blockPos.below().mutable();
                    currBlock = pLevel.getBlockState((BlockPos)mutable);
                    itor = 0;
                    while (mutable.getY() > 0 && this.canBeReplaced(currBlock)) {
                        if (itor != 1) {
                            serverLevel.setBlockAndUpdate((BlockPos)mutable, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).defaultBlockState());
                        } else {
                            serverLevel.setBlockAndUpdate((BlockPos)mutable, ((LayeredBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get())).defaultBlockState());
                        }
                        mutable.move(Direction.DOWN);
                        currBlock = serverLevel.getBlockState((BlockPos)mutable);
                        if (!this.canBeReplaced(currBlock)) {
                            serverLevel.setBlockAndUpdate(mutable.above(), ((LayeredBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get())).defaultBlockState());
                            continue block2;
                        }
                        ++itor;
                    }
                    continue;
                }
                if (!(pLevel instanceof WorldGenRegion)) continue;
                WorldGenRegion worldGenRegion = (WorldGenRegion)pLevel;
                worldGenRegion.setBlock(blockPos, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).defaultBlockState(), 3);
                mutable = blockPos.below().mutable();
                currBlock = pLevel.getBlockState((BlockPos)mutable);
                itor = 0;
                while (mutable.getY() > 0 && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                    if (itor != 1) {
                        worldGenRegion.setBlock((BlockPos)mutable, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).defaultBlockState(), 3);
                    } else {
                        worldGenRegion.setBlock((BlockPos)mutable, ((LayeredBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get())).defaultBlockState(), 3);
                    }
                    mutable.move(Direction.DOWN);
                    currBlock = worldGenRegion.getBlockState((BlockPos)mutable);
                    if (!(currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.MUD_BRICK_SLAB) || currBlock.is(Blocks.MOSS_CARPET) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_FENCE.get()) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_SLAB.get()) || currBlock.is((Block)ModBlocks.WITCH_HAZEL_STAIRS.get()) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                        worldGenRegion.setBlock(mutable.above(), ((LayeredBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get())).defaultBlockState(), 3);
                        continue block2;
                    }
                    ++itor;
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext pContext, Holder<StructureTemplatePool> pStartPool, Optional<ResourceLocation> pStartJigsawName, int pMaxDepth, BlockPos pPos, boolean pUseExpansionHack, Optional<Heightmap.Types> pProjectStartToHeightmap, int pMaxDistanceFromCenter) {
        BlockPos blockpos;
        RegistryAccess registryaccess = pContext.registryAccess();
        ChunkGenerator chunkgenerator = pContext.chunkGenerator();
        StructureTemplateManager structuretemplatemanager = pContext.structureTemplateManager();
        LevelHeightAccessor levelheightaccessor = pContext.heightAccessor();
        WorldgenRandom worldgenrandom = pContext.random();
        Registry registry = registryaccess.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation rotation = Rotation.getRandom((RandomSource)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)pStartPool.value();
        StructurePoolElement structurepoolelement = structuretemplatepool.getRandomTemplate((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (pStartJigsawName.isPresent()) {
            ResourceLocation resourcelocation = pStartJigsawName.get();
            Optional<BlockPos> optional = NatureCovenStructure.getRandomNamedJigsaw(structurepoolelement, resourcelocation, pPos, rotation, structuretemplatemanager, worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)pStartPool.unwrapKey().map(p_248484_ -> p_248484_.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockpos = optional.get();
        } else {
            blockpos = pPos;
        }
        BlockPos vec3i = blockpos.subtract((Vec3i)pPos);
        BlockPos blockpos1 = pPos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.getGroundLevelDelta(), rotation, structurepoolelement.getBoundingBox(structuretemplatemanager, blockpos1, rotation), LiquidSettings.APPLY_WATERLOGGING);
        BoundingBox boundingbox = poolelementstructurepiece.getBoundingBox();
        int i = (boundingbox.maxX() + boundingbox.minX()) / 2;
        int j = (boundingbox.maxZ() + boundingbox.minZ()) / 2;
        int k = pProjectStartToHeightmap.isPresent() ? pPos.getY() + chunkgenerator.getFirstFreeHeight(i, j, pProjectStartToHeightmap.get(), levelheightaccessor, pContext.randomState()) : blockpos1.getY();
        int l = boundingbox.minY() + poolelementstructurepiece.getGroundLevelDelta();
        poolelementstructurepiece.move(0, k - l, 0);
        int i1 = k + vec3i.getY();
        Consumer<StructurePiecesBuilder> pGenerator = structurePiecesBuilder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (pMaxDepth > 0) {
                AABB aabb = new AABB((double)(i - pMaxDistanceFromCenter), (double)(i1 - pMaxDistanceFromCenter), (double)(j - pMaxDistanceFromCenter), (double)(i + pMaxDistanceFromCenter + 1), (double)(i1 + pMaxDistanceFromCenter + 1), (double)(j + pMaxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.ONLY_FIRST);
                NatureCovenStructure.addPieces(pContext.randomState(), pMaxDepth, pUseExpansionHack, chunkgenerator, structuretemplatemanager, levelheightaccessor, (RandomSource)worldgenrandom, (Registry<StructureTemplatePool>)registry, poolelementstructurepiece, list, voxelshape, pProjectStartToHeightmap.orElse(null));
                list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).addPiece(arg_0));
            }
        };
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), pGenerator));
    }

    private static void addPieces(RandomState pRandomState, int pMaxDepth, boolean pUseExpansionHack, ChunkGenerator pChunkGenerator, StructureTemplateManager pStructureTemplateManager, LevelHeightAccessor pLevel, RandomSource pRandom, Registry<StructureTemplatePool> pPools, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> pPieces, VoxelShape p_227221_, Heightmap.Types pType) {
        Placer jigsawplacement$placer = new Placer(pPools, pMaxDepth, pChunkGenerator, pStructureTemplateManager, pPieces, pRandom);
        jigsawplacement$placer.placing.addLast(new PieceState(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, pUseExpansionHack, pLevel, pRandomState, pChunkGenerator, pType);
        }
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement pElement, ResourceLocation pStartJigsawName, BlockPos pPos, Rotation pRotation, StructureTemplateManager pStructureTemplateManager, WorldgenRandom pRandom) {
        List list = pElement.getShuffledJigsawBlocks(pStructureTemplateManager, pPos, pRotation, (RandomSource)pRandom);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf : list) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse((String)usingStructureBlockInf.nbt().getString("name"));
            if (!pStartJigsawName.equals((Object)resourcelocation)) continue;
            optional = Optional.of(usingStructureBlockInf.pos());
            break;
        }
        return optional;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!this.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), startY, chunkPos.getMinBlockZ());
        Optional<Structure.GenerationStub> structurePiecesGenerator = NatureCovenStructure.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.NATURE_COVEN.get();
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> pPools, int pMaxDepth, ChunkGenerator pChunkGenerator, StructureTemplateManager pStructureTemplateManager, List<? super PoolElementStructurePiece> pPieces, RandomSource pRandom) {
            this.pools = pPools;
            this.maxDepth = pMaxDepth;
            this.chunkGenerator = pChunkGenerator;
            this.structureTemplateManager = pStructureTemplateManager;
            this.pieces = pPieces;
            this.random = pRandom;
        }

        void tryPlacingChildren(PoolElementStructurePiece pPiece, MutableObject<VoxelShape> pFree, int pDepth, boolean pUseExpansionHack, LevelHeightAccessor pLevel, RandomState pRandomState, ChunkGenerator chunkGenerator, Heightmap.Types pType) {
            StructurePoolElement structurepoolelement = pPiece.getElement();
            BlockPos blockpos = pPiece.getPosition();
            Rotation rotation = pPiece.getRotation();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.getProjection();
            boolean flag = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = pPiece.getBoundingBox();
            int i = boundingbox.minY();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.getShuffledJigsawBlocks(this.structureTemplateManager, blockpos, rotation, this.random)) {
                StructurePoolElement structurepoolelement1;
                MutableObject<VoxelShape> mutableobject1;
                CompoundTag tag;
                Direction direction = JigsawBlock.getFrontFacing((BlockState)structuretemplate$structureblockinfo.state());
                BlockPos blockpos1 = structuretemplate$structureblockinfo.pos();
                BlockPos blockpos2 = blockpos1.relative(direction);
                int j = blockpos1.getY() - i;
                int k = -1;
                BlockPos forwards = blockpos1.relative(direction, 15);
                BlockPos left = blockpos1.relative(direction, 10).relative(direction.getCounterClockWise(), 6);
                BlockPos right = blockpos1.relative(direction, 10).relative(direction.getClockWise(), 6);
                StructureTemplate.StructureBlockInfo usingStructureBlockInf = structuretemplate$structureblockinfo;
                int groundLevel = chunkGenerator.getFirstFreeHeight(blockpos2.getX(), blockpos2.getZ(), pType, pLevel, pRandomState);
                int distToGround = blockpos2.getY() - groundLevel;
                boolean stairsFlag = false;
                CompoundTag compoundTag = tag = usingStructureBlockInf.nbt() != null ? usingStructureBlockInf.nbt().copy() : new CompoundTag();
                if (distToGround < 3 && distToGround > -5 && tag.contains("name") && tag.getString("name").equals("minecraft:street")) {
                    tag.putString("pool", "hexerei:coven/nature_coven/stairs");
                    tag.putString("target", "minecraft:stairs_up");
                    stairsFlag = true;
                } else if (distToGround > 8 && distToGround <= 15 && tag.contains("name") && tag.getString("name").equals("minecraft:street")) {
                    tag.putString("pool", "hexerei:coven/nature_coven/stairs");
                    tag.putString("target", "minecraft:stairs_down");
                    stairsFlag = true;
                } else if (distToGround > 15 && tag.contains("name") && tag.getString("name").equals("minecraft:street")) {
                    int groundLevelRight = chunkGenerator.getFirstFreeHeight(right.getX(), right.getZ(), pType, pLevel, pRandomState);
                    int distToGroundRight = right.getY() - groundLevelRight;
                    int groundLevelLeft = chunkGenerator.getFirstFreeHeight(left.getX(), left.getZ(), pType, pLevel, pRandomState);
                    int distToGroundLeft = left.getY() - groundLevelLeft;
                    int groundLevelForwards = chunkGenerator.getFirstFreeHeight(forwards.getX(), forwards.getZ(), pType, pLevel, pRandomState);
                    int distToGroundForwards = forwards.getY() - groundLevelForwards;
                    if (this.random.nextFloat() > 0.4f) {
                        if (distToGroundForwards < 8) {
                            tag.putString("pool", "hexerei:coven/nature_coven/streets");
                            tag.putString("target", "minecraft:street");
                            tag.putString("name", "minecraft:street");
                        } else if (distToGroundLeft >= distToGroundRight) {
                            tag.putString("pool", "hexerei:coven/nature_coven/stairs");
                            tag.putString("target", "minecraft:stairs_down_turn_right");
                        } else {
                            tag.putString("pool", "hexerei:coven/nature_coven/stairs");
                            tag.putString("target", "minecraft:stairs_down_turn_left");
                        }
                        stairsFlag = true;
                    }
                } else if (tag.contains("name") && tag.getString("name").equals("minecraft:street") && tag.contains("target") && tag.getString("target").equals("minecraft:stairs_up")) {
                    tag.putString("pool", "hexerei:coven/nature_coven/streets");
                    tag.putString("target", "minecraft:street");
                    tag.putString("name", "minecraft:street");
                } else if (tag.contains("name") && tag.getString("name").equals("minecraft:street") && tag.contains("target") && tag.getString("target").equals("minecraft:stairs_down")) {
                    tag.putString("pool", "hexerei:coven/nature_coven/streets");
                    tag.putString("target", "minecraft:street");
                    tag.putString("name", "minecraft:street");
                } else if (tag.contains("name") && tag.getString("name").equals("minecraft:street") && tag.contains("target") && tag.getString("target").equals("minecraft:stairs_down_turn")) {
                    tag.putString("pool", "hexerei:coven/nature_coven/streets");
                    tag.putString("target", "minecraft:street");
                    tag.putString("name", "minecraft:street");
                }
                usingStructureBlockInf = new StructureTemplate.StructureBlockInfo(structuretemplate$structureblockinfo.pos(), structuretemplate$structureblockinfo.state(), tag);
                ResourceKey<StructureTemplatePool> resourcekey = Placer.readPoolName(usingStructureBlockInf);
                Optional optional = this.pools.getHolder(resourcekey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.location());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.value()).size() == 0 && !holder.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.location());
                    continue;
                }
                Holder holder1 = ((StructureTemplatePool)holder.value()).getFallback();
                if (((StructureTemplatePool)holder1.value()).size() == 0 && !holder1.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder1.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean flag1 = boundingbox.isInside((Vec3i)blockpos2);
                if (flag1) {
                    mutableobject1 = mutableobject;
                    if (mutableobject.getValue() == null) {
                        mutableobject.setValue((Object)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox)));
                    }
                } else {
                    mutableobject1 = pFree;
                }
                ArrayList list = Lists.newArrayList();
                if (pDepth != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.value()).getShuffledTemplates(this.random));
                }
                list.addAll(((StructureTemplatePool)holder1.value()).getShuffledTemplates(this.random));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation rotation1 : Rotation.getShuffled((RandomSource)this.random)) {
                        List list1 = structurepoolelement1.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, rotation1, this.random);
                        BoundingBox boundingbox1 = structurepoolelement1.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, rotation1);
                        int l = pUseExpansionHack && boundingbox1.getYSpan() <= 16 ? list1.stream().mapToInt(p_255598_ -> {
                            if (!boundingbox1.isInside((Vec3i)p_255598_.pos().relative(JigsawBlock.getFrontFacing((BlockState)p_255598_.state())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> resourcekey1 = Placer.readPoolName(p_255598_);
                            Optional optional1 = this.pools.getHolder(resourcekey1);
                            Optional<Holder> optional2 = optional1.map(p_255600_ -> ((StructureTemplatePool)p_255600_.value()).getFallback());
                            int j3 = optional1.map(p_255596_ -> ((StructureTemplatePool)p_255596_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            int k3 = optional2.map(p_255601_ -> ((StructureTemplatePool)p_255601_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(j3, k3);
                        }).max().orElse(0) : 0;
                        ArrayList<StructureTemplate.StructureBlockInfo> list2 = new ArrayList<StructureTemplate.StructureBlockInfo>();
                        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf1 : list1) {
                            CompoundTag tag2 = usingStructureBlockInf1.nbt();
                            if (stairsFlag && tag2 != null && tag2.contains("name") && tag2.getString("name").equals("minecraft:stairs_street")) {
                                tag2.putString("pool", "hexerei:coven/nature_coven/streets");
                                tag2.putString("target", "minecraft:street");
                                tag2.putString("name", "minecraft:street");
                            }
                            list2.add(new StructureTemplate.StructureBlockInfo(usingStructureBlockInf1.pos(), usingStructureBlockInf1.state(), tag2));
                        }
                        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf1 : list2) {
                            int l2;
                            int l1;
                            if (!JigsawBlock.canAttach((StructureTemplate.StructureBlockInfo)usingStructureBlockInf, (StructureTemplate.StructureBlockInfo)usingStructureBlockInf1)) continue;
                            BlockPos blockpos3 = usingStructureBlockInf1.pos();
                            BlockPos blockpos4 = blockpos2.subtract((Vec3i)blockpos3);
                            BoundingBox boundingbox2 = structurepoolelement1.getBoundingBox(this.structureTemplateManager, blockpos4, rotation1);
                            int i1 = boundingbox2.minY();
                            StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.getProjection();
                            boolean flag2 = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                            int j1 = blockpos3.getY();
                            int k1 = j - j1 + JigsawBlock.getFrontFacing((BlockState)usingStructureBlockInf.state()).getStepY();
                            if (flag && flag2) {
                                l1 = i + k1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.getFirstFreeHeight(blockpos1.getX(), blockpos1.getZ(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l1 = k - j1;
                            }
                            int i2 = l1 - i1;
                            BoundingBox boundingbox3 = boundingbox2.moved(0, i2, 0);
                            BlockPos blockpos5 = blockpos4.offset(0, i2, 0);
                            if (l > 0) {
                                int j2 = Math.max(l + 1, boundingbox3.maxY() - boundingbox3.minY());
                                boundingbox3.encapsulate(new BlockPos(boundingbox3.minX(), boundingbox3.minY() + j2, boundingbox3.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox3).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND)) continue;
                            mutableobject1.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.ONLY_FIRST));
                            int i3 = pPiece.getGroundLevelDelta();
                            int k2 = flag2 ? i3 - k1 : structurepoolelement1.getGroundLevelDelta();
                            PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureTemplateManager, structurepoolelement1, blockpos5, k2, rotation1, boundingbox3, LiquidSettings.APPLY_WATERLOGGING);
                            if (flag) {
                                l2 = i + j;
                            } else if (flag2) {
                                l2 = l1 + j1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.getFirstFreeHeight(blockpos1.getX(), blockpos1.getZ(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l2 = k + k1 / 2;
                            }
                            pPiece.addJunction(new JigsawJunction(blockpos2.getX(), l2 - j + i3, blockpos2.getZ(), k1, structuretemplatepool$projection1));
                            poolelementstructurepiece.addJunction(new JigsawJunction(blockpos1.getX(), l2 - j1 + k2, blockpos1.getZ(), -k1, structuretemplatepool$projection));
                            this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                            if (pDepth + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, pDepth + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.StructureBlockInfo pStructureBlockInfo) {
            return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.parse((String)pStructureBlockInfo.nbt().getString("pool")));
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece pPiece, MutableObject<VoxelShape> pFree, int pDepth) {
            this.piece = pPiece;
            this.free = pFree;
            this.depth = pDepth;
        }
    }
}

