/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import github.pitbox46.hiddennames.Config;
import github.pitbox46.hiddennames.HiddenNames;
import github.pitbox46.hiddennames.PlayerDuck;
import github.pitbox46.hiddennames.data.Animation;
import github.pitbox46.hiddennames.data.Animations;
import github.pitbox46.hiddennames.network.NameDataSyncPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class NameData {
    public static final Component.SerializerAdapter COMPONENT_SERIALIZER = new Component.SerializerAdapter((HolderLookup.Provider)RegistryAccess.EMPTY);
    public static final Map<UUID, NameData> DATA = new HashMap<UUID, NameData>(){

        @Override
        public NameData get(Object key) {
            NameData data = (NameData)super.get(key);
            return data != null ? data : new NameData((UUID)key, (Component)Component.literal((String)("ERROR_DESYNC:" + key.toString())), Animations.NO_ANIMATION.get());
        }
    };
    private final UUID uuid;
    private Component displayName;
    private Animation animation;

    public NameData(Player player) {
        this(player, (Boolean)Config.DEFAULT_VISIBLE.get() != false ? Animations.NO_ANIMATION.get() : Animations.HIDDEN.get());
    }

    public NameData(Player player, @Nonnull Animation animation) {
        this(player.getUUID(), ((PlayerDuck)player).hiddenNames$getUnmodifiedDisplayName(), animation);
    }

    public NameData(UUID uuid, Component displayName, Animation animation) {
        this.uuid = uuid;
        this.displayName = displayName;
        this.animation = animation;
    }

    public static void sendSyncData() {
        for (NameData data : DATA.values()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new NameDataSyncPacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    public Animation getAnimation() {
        return this.animation == null ? Animations.NO_ANIMATION.get() : this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation == null ? Animations.NO_ANIMATION.get() : animation;
    }

    public JsonObject serialize(JsonObject json) {
        json.addProperty("uuid", this.uuid.toString());
        json.add("displayName", COMPONENT_SERIALIZER.serialize(this.displayName, Component.class, null));
        json.addProperty("animation", this.animation.key().toString());
        return json;
    }

    public static NameData deserialize(JsonObject json) {
        UUID uuid = UUID.fromString(json.getAsJsonPrimitive("uuid").getAsString());
        MutableComponent component = COMPONENT_SERIALIZER.deserialize(json.get("displayName"), Component.class, null);
        Animation animation = (Animation)HiddenNames.ANIMATION_REGISTRY.get(ResourceLocation.parse((String)json.getAsJsonPrimitive("animation").getAsString()));
        return new NameData(uuid, (Component)component, animation);
    }

    public static JsonArray deserializeAll() {
        JsonArray array = new JsonArray();
        for (NameData data : DATA.values()) {
            array.add((JsonElement)data.serialize(new JsonObject()));
        }
        return array;
    }
}

