/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.mixin;

import github.pitbox46.hiddennames.HiddenNames;
import github.pitbox46.hiddennames.PlayerDuck;
import github.pitbox46.hiddennames.data.NameData;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.event.EventHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerDuck {
    @Shadow(remap=false)
    private Component displayname;
    @Shadow(remap=false)
    @Final
    private Collection<MutableComponent> prefixes;
    @Shadow(remap=false)
    @Final
    private Collection<MutableComponent> suffixes;

    @Shadow
    protected abstract MutableComponent decorateDisplayNameComponent(MutableComponent var1);

    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @ModifyArg(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/scores/PlayerTeam;formatNameForTeam(Lnet/minecraft/world/scores/Team;Lnet/minecraft/network/chat/Component;)Lnet/minecraft/network/chat/MutableComponent;"))
    private Component replaceDisplayName(Component pPlayerName) {
        if (NameData.DATA.containsKey(this.getUUID())) {
            pPlayerName = HiddenNames.getCorrectedName(NameData.DATA.get(this.getUUID()).getDisplayName(), (Team)this.getTeam());
        }
        return pPlayerName;
    }

    @Redirect(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;decorateDisplayNameComponent(Lnet/minecraft/network/chat/MutableComponent;)Lnet/minecraft/network/chat/MutableComponent;"))
    private MutableComponent replaceDecorateDisplayName(Player instance, MutableComponent pDisplayName) {
        if (pDisplayName.getStyle().getClickEvent() == null) {
            pDisplayName = this.decorateDisplayNameComponent(pDisplayName);
        }
        return pDisplayName;
    }

    @Override
    public Component hiddenNames$getUnmodifiedDisplayName() {
        if (this.displayname == null) {
            this.displayname = EventHooks.getPlayerDisplayName((Player)((Player)this), (Component)this.getName());
        }
        MutableComponent mutablecomponent = Component.literal((String)"");
        mutablecomponent = this.prefixes.stream().reduce(mutablecomponent, MutableComponent::append);
        mutablecomponent = mutablecomponent.append((Component)PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)this.displayname));
        mutablecomponent = this.suffixes.stream().reduce(mutablecomponent, MutableComponent::append);
        return this.decorateDisplayNameComponent(mutablecomponent);
    }
}

