/*
 * Decompiled with CFR 0.152.
 */
package com.nivyd.hidechat;

import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="hidechat")
public class ChatFilterMod {
    private static final String TAG_AJUDA = "[Ajuda]";
    private static final String PHRASE_NEED = "precisa de ajuda";
    private static final String PREFIX_MOTIVO = "Motivo:";
    private static final String LABEL_TP = "[Teleportar]";

    public ChatFilterMod(IEventBus modBus) {
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register(ClientEvents.class);
        }
    }

    public static class ClientEvents {
        private static boolean allowHeader(String s) {
            String clean = (s = s.strip()).replaceAll("\u00a7[0-9a-fk-or]", "").toLowerCase();
            return clean.contains(ChatFilterMod.TAG_AJUDA.toLowerCase()) && clean.contains(ChatFilterMod.PHRASE_NEED);
        }

        private static boolean allowMotivo(String s) {
            String clean = s.strip().replaceAll("\u00a7[0-9a-fk-or]", "").toLowerCase();
            return clean.startsWith(ChatFilterMod.PREFIX_MOTIVO.toLowerCase());
        }

        private static boolean allowTeleportLabel(String s) {
            String clean = s.replaceAll("\u00a7[0-9a-fk-or]", "").toLowerCase();
            return clean.contains(ChatFilterMod.LABEL_TP.toLowerCase());
        }

        private static boolean hasTeleportClickEvent(Component c) {
            String v;
            ClickEvent ce;
            Style style = c.getStyle();
            if (style.getClickEvent() != null && (ce = style.getClickEvent()).getAction() == ClickEvent.Action.RUN_COMMAND && ((v = ce.getValue().toLowerCase()).contains("tp") || v.contains("teleport") || v.contains("tpa"))) {
                return true;
            }
            for (Component sib : c.getSiblings()) {
                if (!ClientEvents.hasTeleportClickEvent(sib)) continue;
                return true;
            }
            return false;
        }

        private static boolean hasClickRunOrSuggestMsg(Component c) {
            String v;
            ClickEvent ce;
            Style style = c.getStyle();
            if (style.getClickEvent() != null && ((ce = style.getClickEvent()).getAction() == ClickEvent.Action.RUN_COMMAND || ce.getAction() == ClickEvent.Action.SUGGEST_COMMAND) && ((v = ce.getValue().toLowerCase()).startsWith("/tell ") || v.startsWith("/msg ") || v.startsWith("/w ") || v.startsWith("/r "))) {
                return true;
            }
            for (Component sib : c.getSiblings()) {
                if (!ClientEvents.hasClickRunOrSuggestMsg(sib)) continue;
                return true;
            }
            return false;
        }

        private static boolean looksLikeWhisper(String s) {
            String clean = s.replaceAll("\u00a7[0-9a-fk-or]", "").toLowerCase().strip();
            return clean.contains("sussurra") || clean.startsWith("de ") || clean.startsWith("para ") || clean.contains("whispers") || clean.startsWith("from ") || clean.startsWith("to ") || clean.contains(" whispers ") || clean.contains(" from ") || clean.contains(" to ");
        }

        private static boolean isDarkMageMessage(String s) {
            String clean = s.replaceAll("\u00a7[0-9a-fk-or]", "").toLowerCase().strip();
            return clean.contains("dark mage") || clean.contains("dark nage") || clean.contains("dropped itens") || clean.contains("dropped items") || clean.contains("clear dropped") || clean.contains("will clear");
        }

        private static boolean allowMetaHelpOrTell(Component msg) {
            String plain = msg.getString();
            if (ClientEvents.allowHeader(plain)) {
                return true;
            }
            if (ClientEvents.allowMotivo(plain)) {
                return true;
            }
            if (ClientEvents.allowTeleportLabel(plain)) {
                return true;
            }
            if (ClientEvents.hasTeleportClickEvent(msg)) {
                return true;
            }
            if (ClientEvents.looksLikeWhisper(plain)) {
                return true;
            }
            if (ClientEvents.isDarkMageMessage(plain)) {
                return true;
            }
            return ClientEvents.hasClickRunOrSuggestMsg(msg);
        }

        @SubscribeEvent
        public static void onSystem(ClientChatReceivedEvent.System e) {
            if (!ClientEvents.allowMetaHelpOrTell(e.getMessage())) {
                e.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayer(ClientChatReceivedEvent.Player e) {
            if (!ClientEvents.allowMetaHelpOrTell(e.getMessage())) {
                e.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onOverlayPre(RenderGuiLayerEvent.Pre e) {
        }
    }
}

