/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked;

import com.teamwizardry.librarianlib.core.util.ModLogManager;
import dev.architectury.networking.NetworkManager;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.bridge.PlayerMixinBridgeKt;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.hook.ClientHookProcessor;
import dev.thecodewarrior.hooked.hook.Hook;
import dev.thecodewarrior.hooked.hook.HookEvent;
import dev.thecodewarrior.hooked.network.GameRuleSyncS2CPacket;
import dev.thecodewarrior.hooked.network.HookEventsS2CPacket;
import dev.thecodewarrior.hooked.network.HookedPlayerDataFullSyncS2CPacket;
import dev.thecodewarrior.hooked.network.HookedPlayerDataPartialSyncS2CPacket;
import dev.thecodewarrior.hooked.util.CircularMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/thecodewarrior/hooked/HookClientNetworking;", "", "<init>", "()V", "", "registerNetworking", "", "entityId", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "getHookDataByEntityId", "(I)Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "Ldev/thecodewarrior/hooked/network/HookEventsS2CPacket;", "packet", "Ldev/architectury/networking/NetworkManager$PacketContext;", "context", "processHookEventsPacket", "(Ldev/thecodewarrior/hooked/network/HookEventsS2CPacket;Ldev/architectury/networking/NetworkManager$PacketContext;)V", "Ldev/thecodewarrior/hooked/network/HookedPlayerDataFullSyncS2CPacket;", "processFullSyncPacket", "(Ldev/thecodewarrior/hooked/network/HookedPlayerDataFullSyncS2CPacket;Ldev/architectury/networking/NetworkManager$PacketContext;)V", "Ldev/thecodewarrior/hooked/network/HookedPlayerDataPartialSyncS2CPacket;", "processPartialSyncPacket", "(Ldev/thecodewarrior/hooked/network/HookedPlayerDataPartialSyncS2CPacket;Ldev/architectury/networking/NetworkManager$PacketContext;)V", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nHookClientNetworking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HookClientNetworking.kt\ndev/thecodewarrior/hooked/HookClientNetworking\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ModLogManager.kt\ncom/teamwizardry/librarianlib/core/util/ModLogManager\n*L\n1#1,94:1\n1863#2,2:95\n1230#2,4:97\n487#3,7:101\n58#4:108\n*S KotlinDebug\n*F\n+ 1 HookClientNetworking.kt\ndev/thecodewarrior/hooked/HookClientNetworking\n*L\n65#1:95,2\n75#1:97,4\n76#1:101,7\n20#1:108\n*E\n"})
public final class HookClientNetworking {
    @NotNull
    public static final HookClientNetworking INSTANCE = new HookClientNetworking();
    @NotNull
    private static final Logger logger;

    private HookClientNetworking() {
    }

    public final void registerNetworking() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, GameRuleSyncS2CPacket.Companion.getID(), GameRuleSyncS2CPacket.Companion.getCODEC(), HookClientNetworking::registerNetworking$lambda$0);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, HookEventsS2CPacket.Companion.getID(), HookEventsS2CPacket.Companion.getCODEC(), this::processHookEventsPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, HookedPlayerDataFullSyncS2CPacket.Companion.getID(), HookedPlayerDataFullSyncS2CPacket.Companion.getCODEC(), this::processFullSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, HookedPlayerDataPartialSyncS2CPacket.Companion.getID(), HookedPlayerDataPartialSyncS2CPacket.Companion.getCODEC(), this::processPartialSyncPacket);
    }

    private final HookedPlayerData getHookDataByEntityId(int entityId) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel world = clientLevel;
        Entity entity = world.getEntity(entityId);
        if (entity == null) {
            return null;
        }
        Entity entity2 = entity;
        if (!(entity2 instanceof Player)) {
            logger.warn("Entity " + entityId + " is not a player, so it has no HookedPlayerData");
            return null;
        }
        return PlayerMixinBridgeKt.hookData((Player)entity2);
    }

    private final void processHookEventsPacket(HookEventsS2CPacket packet, NetworkManager.PacketContext context) {
        HookedPlayerData hookedPlayerData = this.getHookDataByEntityId(packet.getEntityId());
        if (hookedPlayerData == null) {
            return;
        }
        HookedPlayerData data = hookedPlayerData;
        Iterable $this$forEach$iv = packet.getEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HookEvent it = (HookEvent)element$iv;
            boolean bl = false;
            ClientHookProcessor.INSTANCE.triggerServerEvent(data, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processFullSyncPacket(HookedPlayerDataFullSyncS2CPacket packet, NetworkManager.PacketContext context) {
        void $this$filterKeys$iv;
        Integer it;
        boolean bl;
        CircularMap<Integer, Hook> circularMap;
        Map $this$associateByTo$iv;
        HookedPlayerData hookedPlayerData = this.getHookDataByEntityId(packet.getEntityId());
        if (hookedPlayerData == null) {
            return;
        }
        HookedPlayerData data = hookedPlayerData;
        data.setProperties(packet.getProperties());
        Iterable iterable = packet.getHooks();
        CircularMap<Integer, Hook> destination$iv = (CircularMap<Integer, Hook>)((Object)new TreeMap());
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator2 = $this$associateByTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            Hook hook = (Hook)t;
            circularMap = destination$iv;
            bl = false;
            circularMap.put(((Hook)((Object)it)).getId(), (Hook)t);
        }
        TreeMap newHooks = (TreeMap)((Object)destination$iv);
        $this$associateByTo$iv = data.getHooks();
        circularMap = data.getSyncStatus().getRecentHooks();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            it = (Integer)entry.getKey();
            bl = false;
            if (!(!((Map)newHooks).containsKey(it))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        circularMap.putAll(result$iv);
        data.setHooks(newHooks);
        data.getController().readSyncState(packet.getControllerState(), packet.getInitial());
    }

    private final void processPartialSyncPacket(HookedPlayerDataPartialSyncS2CPacket packet, NetworkManager.PacketContext context) {
        HookedPlayerData hookedPlayerData = this.getHookDataByEntityId(packet.getEntityId());
        if (hookedPlayerData == null) {
            return;
        }
        HookedPlayerData data = hookedPlayerData;
        for (Hook hook : packet.getDirtyHooks()) {
            if (hook.getState() == Hook.State.REMOVED) {
                data.getHooks().remove(hook.getId());
                data.getSyncStatus().addRecentHook(hook);
                continue;
            }
            ((Map)data.getHooks()).put(hook.getId(), hook);
        }
    }

    private static final void registerNetworking$lambda$0(GameRuleSyncS2CPacket payload, NetworkManager.PacketContext context) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        GameRules gameRules = clientLevel.getGameRules();
        Intrinsics.checkNotNullExpressionValue((Object)gameRules, (String)"getGameRules(...)");
        payload.applyTo(gameRules);
    }

    static {
        ModLogManager this_$iv = Hooked.INSTANCE.getLogManager();
        boolean $i$f$makeLogger = false;
        logger = this_$iv.makeLogger(HookClientNetworking.class);
    }
}

