/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.hook;

import com.teamwizardry.librarianlib.core.util.Client;
import com.teamwizardry.librarianlib.core.util.ModLogManager;
import dev.architectury.networking.NetworkManager;
import dev.thecodewarrior.hooked.HookGameRules;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.bridge.PlayerMixinBridgeKt;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.hook.CommonHookProcessor;
import dev.thecodewarrior.hooked.hook.Hook;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.hook.HookEvent;
import dev.thecodewarrior.hooked.hook.HookPlayerController;
import dev.thecodewarrior.hooked.hook.HookProcessorContext;
import dev.thecodewarrior.hooked.hooks.BasicHookPlayerController;
import dev.thecodewarrior.hooked.item.HookProperties;
import dev.thecodewarrior.hooked.network.ClientHookSyncC2SPacket;
import dev.thecodewarrior.hooked.network.HookJumpC2SPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ=\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\f\u001a\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#R(\u0010%\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b%\u0010&\u0012\u0004\b+\u0010\u0003\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00063"}, d2={"Ldev/thecodewarrior/hooked/hook/ClientHookProcessor;", "Ldev/thecodewarrior/hooked/hook/CommonHookProcessor;", "<init>", "()V", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "data", "Ldev/thecodewarrior/hooked/hook/HookEvent;", "event", "", "triggerServerEvent", "(Ldev/thecodewarrior/hooked/capability/HookedPlayerData;Ldev/thecodewarrior/hooked/hook/HookEvent;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "pitch", "yaw", "", "sneaking", "fireHook", "(Lnet/minecraft/world/entity/player/Player;Ldev/thecodewarrior/hooked/capability/HookedPlayerData;Lnet/minecraft/world/phys/Vec3;FFZ)V", "doubleJump", "jump", "(Ldev/thecodewarrior/hooked/capability/HookedPlayerData;ZZ)V", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "Ldev/thecodewarrior/hooked/hook/HookActiveReason;", "reason", "isHookActive", "(Lnet/minecraft/world/entity/player/Player;Ldev/thecodewarrior/hooked/hook/HookActiveReason;)Z", "Lnet/minecraft/client/player/LocalPlayer;", "", "Lnet/minecraft/world/phys/AABB;", "previewJumpTargets", "(Lnet/minecraft/client/player/LocalPlayer;)Ljava/util/List;", "", "hudCooldown", "D", "getHudCooldown", "()D", "setHudCooldown", "(D)V", "getHudCooldown$annotations", "", "cooldownCounter", "I", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "Context", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nClientHookProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientHookProcessor.kt\ndev/thecodewarrior/hooked/hook/ClientHookProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ModLogManager.kt\ncom/teamwizardry/librarianlib/core/util/ModLogManager\n*L\n1#1,165:1\n2632#2,3:166\n58#3:169\n*S KotlinDebug\n*F\n+ 1 ClientHookProcessor.kt\ndev/thecodewarrior/hooked/hook/ClientHookProcessor\n*L\n159#1:166,3\n164#1:169\n*E\n"})
public final class ClientHookProcessor
extends CommonHookProcessor {
    @NotNull
    public static final ClientHookProcessor INSTANCE = new ClientHookProcessor();
    private static double hudCooldown;
    private static int cooldownCounter;
    @NotNull
    private static final Logger logger;

    private ClientHookProcessor() {
    }

    public static final double getHudCooldown() {
        return hudCooldown;
    }

    public static final void setHudCooldown(double d) {
        hudCooldown = d;
    }

    @JvmStatic
    public static /* synthetic */ void getHudCooldown$annotations() {
    }

    public final void triggerServerEvent(@NotNull HookedPlayerData data, @NotNull HookEvent event) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (CollectionsKt.contains((Iterable)data.getSyncStatus().getRecentEvents(), (Object)event)) {
            return;
        }
        new Context(data).fireEvent(event);
    }

    public final void fireHook(@NotNull Player player, @NotNull HookedPlayerData data, @NotNull Vec3 pos, float pitch, float yaw, boolean sneaking) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (player.isFallFlying() && !player.level().getGameRules().getBoolean(HookGameRules.ALLOW_HOOKS_WHILE_FLYING)) {
            return;
        }
        if (data.getMaxHooks() > 0) {
            MultiPlayerGameMode multiPlayerGameMode = Client.getMinecraft().gameMode;
            if ((multiPlayerGameMode != null ? multiPlayerGameMode.getPlayerMode() : null) != GameType.SPECTATOR) {
                ArrayList ids = new ArrayList();
                data.getController().fireHooks(new Context(data), pos, pitch, yaw, sneaking);
            }
        }
    }

    public final void jump(@NotNull HookedPlayerData data, boolean doubleJump, boolean sneaking) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.getMaxHooks() > 0) {
            data.getController().jump(new Context(data), doubleJump, sneaking);
            NetworkManager.sendToServer((CustomPacketPayload)new HookJumpC2SPacket(doubleJump, sneaking));
        }
    }

    @Override
    public void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HookedPlayerData data = PlayerMixinBridgeKt.hookData(player);
        this.applyHookMotion(new Context(data));
        if (Intrinsics.areEqual((Object)player, (Object)Client.getPlayer())) {
            data.getController().update(new Context(data));
            if (data.getProperties().getCooldown() == 0 || cooldownCounter > data.getProperties().getCooldown()) {
                cooldownCounter = 0;
                hudCooldown = 0.0;
            } else {
                int n;
                hudCooldown = cooldownCounter > 0 ? ((cooldownCounter = (n = cooldownCounter) + -1) == 0 ? 0.01 : (double)cooldownCounter / (double)data.getProperties().getCooldown()) : 0.0;
            }
            if (!data.getSyncStatus().getSyncToServerHooks().isEmpty()) {
                NetworkManager.sendToServer((CustomPacketPayload)new ClientHookSyncC2SPacket(CollectionsKt.toList((Iterable)data.getSyncStatus().getSyncToServerHooks().values())));
            }
        }
        data.getSyncStatus().getSyncToServerHooks().clear();
    }

    @Override
    public boolean isHookActive(@NotNull Player player, @NotNull HookActiveReason reason) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        HookedPlayerData data = PlayerMixinBridgeKt.hookData(player);
        return data.getController().isActive(new Context(data), reason);
    }

    @NotNull
    public final List<AABB> previewJumpTargets(@NotNull LocalPlayer player) {
        boolean bl;
        BasicHookPlayerController controller;
        HookedPlayerData data;
        block6: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            data = PlayerMixinBridgeKt.hookData((Player)player);
            HookPlayerController hookPlayerController = data.getController();
            BasicHookPlayerController basicHookPlayerController = hookPlayerController instanceof BasicHookPlayerController ? (BasicHookPlayerController)hookPlayerController : null;
            if (basicHookPlayerController == null) {
                return CollectionsKt.emptyList();
            }
            controller = basicHookPlayerController;
            Collection collection = data.getHooks().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Hook it = (Hook)element$iv;
                    boolean bl2 = false;
                    if (!(it.getState() == Hook.State.PLANTED)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        List list = controller.computeJumpTargets(new Context(data));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static {
        ModLogManager this_$iv = Hooked.INSTANCE.getLogManager();
        boolean $i$f$makeLogger = false;
        logger = this_$iv.makeLogger(ClientHookProcessor.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ;\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\bJ\u000f\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\bJ'\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010-\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u00101\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00105\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00109\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000f0:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010>\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010C\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Ldev/thecodewarrior/hooked/hook/ClientHookProcessor$Context;", "Ldev/thecodewarrior/hooked/hook/HookProcessorContext;", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "data", "<init>", "(Ldev/thecodewarrior/hooked/capability/HookedPlayerData;)V", "", "triggerCooldown", "()V", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "pitch", "yaw", "Lkotlin/Function1;", "Ldev/thecodewarrior/hooked/hook/Hook;", "modifyFn", "fireHook", "(Lnet/minecraft/world/phys/Vec3;FFLkotlin/jvm/functions/Function1;)V", "hook", "", "sendToServer", "sendToClient", "sendToOthers", "syncHook", "(Ldev/thecodewarrior/hooked/hook/Hook;ZZZ)V", "forceFullSyncToClient", "forceFullSyncToOthers", "Lnet/minecraft/sounds/SoundEvent;", "sound", "volume", "playFeedbackSound", "(Lnet/minecraft/sounds/SoundEvent;FF)V", "playWorldSound", "(Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/world/phys/Vec3;FF)V", "Ldev/thecodewarrior/hooked/hook/HookEvent;", "event", "fireEvent", "(Ldev/thecodewarrior/hooked/hook/HookEvent;)V", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "getData", "()Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "Ldev/thecodewarrior/hooked/item/HookProperties;", "getProperties", "()Ldev/thecodewarrior/hooked/item/HookProperties;", "properties", "Ldev/thecodewarrior/hooked/hook/HookPlayerController;", "getController", "()Ldev/thecodewarrior/hooked/hook/HookPlayerController;", "controller", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/level/Level;", "getWorld", "()Lnet/minecraft/world/level/Level;", "world", "", "getHooks", "()Ljava/util/Collection;", "hooks", "isSelfClient", "()Z", "", "getCooldown", "()I", "cooldown", "hooked-common"})
    public static final class Context
    implements HookProcessorContext {
        @NotNull
        private final HookedPlayerData data;

        public Context(@NotNull HookedPlayerData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        @NotNull
        public HookedPlayerData getData() {
            return this.data;
        }

        @Override
        @NotNull
        public HookProperties getProperties() {
            return this.getData().getProperties();
        }

        @Override
        @NotNull
        public HookPlayerController getController() {
            return this.getData().getController();
        }

        @Override
        @NotNull
        public Player getPlayer() {
            return this.getData().getPlayer();
        }

        @Override
        @NotNull
        public Level getWorld() {
            Level level = this.getData().getPlayer().level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getWorld(...)");
            return level;
        }

        @Override
        @NotNull
        public Collection<Hook> getHooks() {
            Collection<Hook> collection = this.getData().getHooks().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            return collection;
        }

        @Override
        public boolean isSelfClient() {
            return Intrinsics.areEqual((Object)this.getData().getPlayer(), (Object)Client.getPlayer());
        }

        @Override
        public int getCooldown() {
            return cooldownCounter;
        }

        @Override
        public void triggerCooldown() {
            cooldownCounter = this.getProperties().getCooldown();
        }

        @Override
        public void fireHook(@NotNull Vec3 pos, float pitch, float yaw, @NotNull Function1<? super Hook, Unit> modifyFn) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(modifyFn, (String)"modifyFn");
            Hook hook = new Hook(this.getData().nextId(), this.getData().getProperties().getHookModel().getHookLength(), pos, pitch, yaw, Hook.State.EXTENDING, new BlockPos(0, 0, 0), 0);
            hook.setFirstTick(true);
            ((Map)this.getData().getHooks()).put(hook.getId(), hook);
            this.getData().getSyncStatus().syncToServer(hook);
            modifyFn.invoke((Object)hook);
        }

        @Override
        public void syncHook(@NotNull Hook hook, boolean sendToServer, boolean sendToClient, boolean sendToOthers) {
            Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
            if (sendToServer) {
                this.getData().getSyncStatus().syncToServer(hook);
            }
        }

        @Override
        public void forceFullSyncToClient() {
        }

        @Override
        public void forceFullSyncToOthers() {
        }

        @Override
        public void playFeedbackSound(@NotNull SoundEvent sound, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            if (Intrinsics.areEqual((Object)this.getPlayer(), (Object)Client.getPlayer())) {
                logger.debug("Playing feedback sound {}", (Object)sound.getLocation());
                this.getPlayer().playNotifySound(sound, this.getPlayer().getSoundSource(), volume, pitch);
            } else {
                logger.debug("Skipping feedback sound for other player {}", (Object)sound.getLocation());
            }
        }

        @Override
        public void playWorldSound(@NotNull SoundEvent sound, @NotNull Vec3 pos, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            if (Intrinsics.areEqual((Object)this.getPlayer(), (Object)Client.getPlayer())) {
                logger.debug("Playing client world sound {}", (Object)sound.getLocation());
                this.getPlayer().level().playSound(this.getPlayer(), pos.x, pos.y, pos.z, sound, SoundSource.PLAYERS, volume, pitch);
            } else {
                logger.debug("Skipping client world sound for other player {}", (Object)sound.getLocation());
            }
        }

        @Override
        public void fireEvent(@NotNull HookEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getData().getSyncStatus().getRecentEvents().add(event);
            Hook hook = (Hook)this.getData().getHooks().get(event.getId());
            if (hook == null && (hook = (Hook)this.getData().getSyncStatus().getRecentHooks().get(event.getId())) == null) {
                return;
            }
            Hook hook2 = hook;
            this.getController().triggerEvent(this, hook2, event);
        }
    }
}

