/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.hook;

import com.teamwizardry.librarianlib.core.util.ModLogManager;
import dev.architectury.networking.NetworkManager;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.bridge.PlayerMixinBridgeKt;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.hook.CommonHookProcessor;
import dev.thecodewarrior.hooked.hook.Hook;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.hook.HookEvent;
import dev.thecodewarrior.hooked.hook.HookPlayerController;
import dev.thecodewarrior.hooked.hook.HookProcessorContext;
import dev.thecodewarrior.hooked.item.HookProperties;
import dev.thecodewarrior.hooked.network.HookEventsS2CPacket;
import dev.thecodewarrior.hooked.network.HookedPlayerDataFullSyncS2CPacket;
import dev.thecodewarrior.hooked.platform.HookedPlatformCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Ldev/thecodewarrior/hooked/hook/ServerHookProcessor;", "Ldev/thecodewarrior/hooked/hook/CommonHookProcessor;", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "onPlayerWorldChanged", "(Lnet/minecraft/server/level/ServerPlayer;)V", "target", "doInitialSync", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;)V", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "data", "", "doubleJump", "sneaking", "jump", "(Ldev/thecodewarrior/hooked/capability/HookedPlayerData;ZZ)V", "Lnet/minecraft/world/entity/player/Player;", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "Ldev/thecodewarrior/hooked/hook/HookActiveReason;", "reason", "isHookActive", "(Lnet/minecraft/world/entity/player/Player;Ldev/thecodewarrior/hooked/hook/HookActiveReason;)Z", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "Context", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nServerHookProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerHookProcessor.kt\ndev/thecodewarrior/hooked/hook/ServerHookProcessor\n+ 2 ModLogManager.kt\ncom/teamwizardry/librarianlib/core/util/ModLogManager\n*L\n1#1,146:1\n58#2:147\n*S KotlinDebug\n*F\n+ 1 ServerHookProcessor.kt\ndev/thecodewarrior/hooked/hook/ServerHookProcessor\n*L\n145#1:147\n*E\n"})
public final class ServerHookProcessor
extends CommonHookProcessor {
    @NotNull
    public static final ServerHookProcessor INSTANCE = new ServerHookProcessor();
    @NotNull
    private static final Logger logger;

    private ServerHookProcessor() {
    }

    public final void onPlayerWorldChanged(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerMixinBridgeKt.hookData((Player)player).getHooks().clear();
        this.doInitialSync(player, player);
    }

    public final void doInitialSync(@NotNull ServerPlayer player, @NotNull ServerPlayer target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)PlayerMixinBridgeKt.hookData((Player)target).createFullSyncPacket(true));
    }

    public final void jump(@NotNull HookedPlayerData data, boolean doubleJump, boolean sneaking) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.getMaxHooks() > 0) {
            data.getController().jump(new Context(data), doubleJump, sneaking);
        }
    }

    @Override
    public void tick(@NotNull Player player) {
        HookProperties equippedProperties;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ServerPlayer cfr_ignored_0 = (ServerPlayer)player;
        HookedPlayerData data = PlayerMixinBridgeKt.hookData(player);
        HookProperties hookProperties = HookedPlatformCommon.Companion.getInstance().getEquippedHook(player);
        if (hookProperties == null) {
            hookProperties = equippedProperties = HookProperties.Companion.getNONE();
        }
        if (!Intrinsics.areEqual((Object)data.getProperties(), (Object)equippedProperties)) {
            data.getHooks().clear();
            data.setProperties(equippedProperties);
            data.getSyncStatus().setForceFullSyncToClient(true);
            data.getSyncStatus().setForceFullSyncToOthers(true);
        }
        Context context = new Context(data);
        this.applyHookMotion(context);
        data.getController().update(context);
        HookedPlayerDataFullSyncS2CPacket fullSyncPacket = data.createFullSyncPacket(false);
        List sendToSelf = new ArrayList();
        List sendToOthers = new ArrayList();
        if (data.getSyncStatus().getForceFullSyncToClient()) {
            sendToSelf.add(fullSyncPacket);
        } else if (!data.getSyncStatus().getSyncToClientHooks().isEmpty()) {
            sendToSelf.add(data.createPartialSyncPacket(true));
        }
        if (data.getSyncStatus().getForceFullSyncToOthers()) {
            sendToOthers.add(fullSyncPacket);
        } else if (!data.getSyncStatus().getSyncToOthersHooks().isEmpty()) {
            sendToOthers.add(data.createPartialSyncPacket(false));
        }
        if (!((Collection)data.getSyncStatus().getQueuedEvents()).isEmpty()) {
            HookEventsS2CPacket packet = new HookEventsS2CPacket(((ServerPlayer)player).getId(), new ArrayList(data.getSyncStatus().getQueuedEvents()));
            sendToOthers.add(packet);
        }
        for (CustomPacketPayload packet : sendToSelf) {
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet);
        }
        if (!((Collection)sendToOthers).isEmpty()) {
            HookedPlatformCommon.Companion.getInstance().sendToPlayersTrackingEntity((Entity)player, sendToOthers);
        }
        data.getSyncStatus().setForceFullSyncToClient(false);
        data.getSyncStatus().setForceFullSyncToOthers(false);
        data.getSyncStatus().getSyncToClientHooks().clear();
        data.getSyncStatus().getSyncToOthersHooks().clear();
        data.getSyncStatus().getQueuedEvents().clear();
    }

    @Override
    public boolean isHookActive(@NotNull Player player, @NotNull HookActiveReason reason) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        HookedPlayerData data = PlayerMixinBridgeKt.hookData(player);
        return data.getController().isActive(new Context(data), reason);
    }

    static {
        ModLogManager this_$iv = Hooked.INSTANCE.getLogManager();
        boolean $i$f$makeLogger = false;
        logger = this_$iv.makeLogger(ServerHookProcessor.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ;\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\bJ\u000f\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\bJ'\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010-\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u00101\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00105\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00109\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000f0:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001a\u0010>\u001a\u00020\u00148\u0016X\u0096D\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b>\u0010@R\u0014\u0010D\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Ldev/thecodewarrior/hooked/hook/ServerHookProcessor$Context;", "Ldev/thecodewarrior/hooked/hook/HookProcessorContext;", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "data", "<init>", "(Ldev/thecodewarrior/hooked/capability/HookedPlayerData;)V", "", "triggerCooldown", "()V", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "pitch", "yaw", "Lkotlin/Function1;", "Ldev/thecodewarrior/hooked/hook/Hook;", "modifyFn", "fireHook", "(Lnet/minecraft/world/phys/Vec3;FFLkotlin/jvm/functions/Function1;)V", "hook", "", "sendToServer", "sendToClient", "sendToOthers", "syncHook", "(Ldev/thecodewarrior/hooked/hook/Hook;ZZZ)V", "forceFullSyncToClient", "forceFullSyncToOthers", "Lnet/minecraft/sounds/SoundEvent;", "sound", "volume", "playFeedbackSound", "(Lnet/minecraft/sounds/SoundEvent;FF)V", "playWorldSound", "(Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/world/phys/Vec3;FF)V", "Ldev/thecodewarrior/hooked/hook/HookEvent;", "event", "fireEvent", "(Ldev/thecodewarrior/hooked/hook/HookEvent;)V", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "getData", "()Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "Ldev/thecodewarrior/hooked/item/HookProperties;", "getProperties", "()Ldev/thecodewarrior/hooked/item/HookProperties;", "properties", "Ldev/thecodewarrior/hooked/hook/HookPlayerController;", "getController", "()Ldev/thecodewarrior/hooked/hook/HookPlayerController;", "controller", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/level/Level;", "getWorld", "()Lnet/minecraft/world/level/Level;", "world", "", "getHooks", "()Ljava/util/Collection;", "hooks", "isSelfClient", "Z", "()Z", "", "getCooldown", "()I", "cooldown", "hooked-common"})
    public static final class Context
    implements HookProcessorContext {
        @NotNull
        private final HookedPlayerData data;
        private final boolean isSelfClient;

        public Context(@NotNull HookedPlayerData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        @NotNull
        public HookedPlayerData getData() {
            return this.data;
        }

        @Override
        @NotNull
        public HookProperties getProperties() {
            return this.getData().getProperties();
        }

        @Override
        @NotNull
        public HookPlayerController getController() {
            return this.getData().getController();
        }

        @Override
        @NotNull
        public Player getPlayer() {
            return this.getData().getPlayer();
        }

        @Override
        @NotNull
        public Level getWorld() {
            Level level = this.getData().getPlayer().level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getWorld(...)");
            return level;
        }

        @Override
        @NotNull
        public Collection<Hook> getHooks() {
            Collection<Hook> collection = this.getData().getHooks().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            return collection;
        }

        @Override
        public boolean isSelfClient() {
            return this.isSelfClient;
        }

        @Override
        public int getCooldown() {
            return 0;
        }

        @Override
        public void triggerCooldown() {
        }

        @Override
        public void fireHook(@NotNull Vec3 pos, float pitch, float yaw, @NotNull Function1<? super Hook, Unit> modifyFn) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(modifyFn, (String)"modifyFn");
        }

        @Override
        public void syncHook(@NotNull Hook hook, boolean sendToServer, boolean sendToClient, boolean sendToOthers) {
            Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
            if (sendToClient) {
                this.getData().getSyncStatus().syncToClient(hook);
            }
            if (sendToOthers) {
                this.getData().getSyncStatus().syncToOthers(hook);
            }
        }

        @Override
        public void forceFullSyncToClient() {
            this.getData().getSyncStatus().setForceFullSyncToClient(true);
        }

        @Override
        public void forceFullSyncToOthers() {
            this.getData().getSyncStatus().setForceFullSyncToOthers(true);
        }

        @Override
        public void playFeedbackSound(@NotNull SoundEvent sound, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        }

        @Override
        public void playWorldSound(@NotNull SoundEvent sound, @NotNull Vec3 pos, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            logger.debug("Playing server world sound {}", (Object)sound.getLocation());
            this.getPlayer().level().playSound(this.getPlayer(), pos.x, pos.y, pos.z, sound, SoundSource.PLAYERS, volume, pitch);
        }

        @Override
        public void fireEvent(@NotNull HookEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getData().getSyncStatus().getQueuedEvents().add(event);
            Hook hook = (Hook)this.getData().getHooks().get(event.getId());
            if (hook == null) {
                return;
            }
            Hook hook2 = hook;
            this.getController().triggerEvent(this, hook2, event);
        }
    }
}

