/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.hooks;

import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.hook.Hook;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.hook.HookControllerDelegate;
import dev.thecodewarrior.hooked.hook.HookPlayerController;
import dev.thecodewarrior.hooked.hooks.FlightHookBehavior;
import dev.thecodewarrior.hooked.util.ConstraintResult;
import dev.thecodewarrior.hooked.util.DynamicHull;
import dev.thecodewarrior.hooked.util.FadeTimer;
import dev.thecodewarrior.hooked.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010&\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b&\u0010'J'\u0010)\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\u0006\u0010(\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\n2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b-\u0010\u0016J\u001f\u0010/\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00103\u001a\u00020\u00102\u0006\u0010!\u001a\u00020 2\u0006\u00102\u001a\u000201H\u0016\u00a2\u0006\u0004\b3\u00104J(\u00109\u001a\u00020\n2\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\n05\u00a2\u0006\u0002\b7H\u0002\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b;\u0010\u0016J\u000f\u0010<\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b<\u0010\u0016J\u000f\u0010=\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b=\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010>\u001a\u0004\b?\u0010@R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010A\u001a\u0004\bB\u0010CR\u0017\u0010E\u001a\u00020D8\u0006\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\"\u0010I\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\"\u0010O\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010J\u001a\u0004\bO\u0010L\"\u0004\bP\u0010NR\"\u0010Q\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010J\u001a\u0004\bR\u0010L\"\u0004\bS\u0010NR\"\u0010T\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010J\u001a\u0004\bT\u0010L\"\u0004\bU\u0010NR\"\u0010W\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u0014\u0010]\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0014\u0010_\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010^R\u0016\u0010`\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010J\u00a8\u0006a"}, d2={"Ldev/thecodewarrior/hooked/hooks/FlightHookPlayerController;", "Ldev/thecodewarrior/hooked/hook/HookPlayerController;", "Lnet/minecraft/world/entity/player/Player;", "player", "Ldev/thecodewarrior/hooked/hooks/FlightHookBehavior;", "behavior", "<init>", "(Lnet/minecraft/world/entity/player/Player;Ldev/thecodewarrior/hooked/hooks/FlightHookBehavior;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "saveState", "(Lnet/minecraft/nbt/CompoundTag;)V", "loadState", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "", "initial", "writeSyncState", "(Lnet/minecraft/network/FriendlyByteBuf;Z)V", "readSyncState", "remove", "()V", "Lnet/minecraft/world/phys/Vec3;", "pos", "direction", "", "cosThreshold", "Ldev/thecodewarrior/hooked/hook/Hook;", "hook", "isPointingAtHook", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;DLdev/thecodewarrior/hooked/hook/Hook;)Z", "Ldev/thecodewarrior/hooked/hook/HookControllerDelegate;", "delegate", "", "pitch", "yaw", "sneaking", "fireHooks", "(Ldev/thecodewarrior/hooked/hook/HookControllerDelegate;Lnet/minecraft/world/phys/Vec3;FFZ)V", "doubleJump", "jump", "(Ldev/thecodewarrior/hooked/hook/HookControllerDelegate;ZZ)V", "update", "(Ldev/thecodewarrior/hooked/hook/HookControllerDelegate;)V", "updateFlightEnabled", "baseRange", "modifyHookRange", "(DLdev/thecodewarrior/hooked/hook/Hook;)D", "Ldev/thecodewarrior/hooked/hook/HookActiveReason;", "reason", "isActive", "(Ldev/thecodewarrior/hooked/hook/HookControllerDelegate;Ldev/thecodewarrior/hooked/hook/HookActiveReason;)Z", "Lkotlin/Function1;", "Lnet/minecraft/world/entity/player/Abilities;", "Lkotlin/ExtensionFunctionType;", "fn", "updatePlayerAbilities", "(Lkotlin/jvm/functions/Function1;)V", "enableFlight", "disableFlight", "fixExternalFlight", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "Ldev/thecodewarrior/hooked/hooks/FlightHookBehavior;", "getBehavior", "()Ldev/thecodewarrior/hooked/hooks/FlightHookBehavior;", "Ldev/thecodewarrior/hooked/util/DynamicHull;", "hull", "Ldev/thecodewarrior/hooked/util/DynamicHull;", "getHull", "()Ldev/thecodewarrior/hooked/util/DynamicHull;", "hasExternalFlight", "Z", "getHasExternalFlight", "()Z", "setHasExternalFlight", "(Z)V", "isFlightEnabled", "setFlightEnabled", "stopFallDamage", "getStopFallDamage", "setStopFallDamage", "isInsideHull", "setInsideHull", "Ldev/thecodewarrior/hooked/util/FadeTimer;", "showHullTimer", "Ldev/thecodewarrior/hooked/util/FadeTimer;", "getShowHullTimer", "()Ldev/thecodewarrior/hooked/util/FadeTimer;", "setShowHullTimer", "(Ldev/thecodewarrior/hooked/util/FadeTimer;)V", "allowedFlightRange", "D", "retractThreshold", "wasFlying", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nFlightHookPlayerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlightHookPlayerController.kt\ndev/thecodewarrior/hooked/hooks/FlightHookPlayerController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1557#2:260\n1628#2,3:261\n774#2:264\n865#2,2:265\n1971#2,14:267\n1755#2,3:281\n774#2:284\n865#2,2:285\n1557#2:287\n1628#2,3:288\n*S KotlinDebug\n*F\n+ 1 FlightHookPlayerController.kt\ndev/thecodewarrior/hooked/hooks/FlightHookPlayerController\n*L\n82#1:260\n82#1:261,3\n83#1:264\n83#1:265,2\n84#1:267,14\n106#1:281,3\n131#1:284\n131#1:285,2\n141#1:287\n141#1:288,3\n*E\n"})
public class FlightHookPlayerController
extends HookPlayerController {
    @NotNull
    private final Player player;
    @NotNull
    private final FlightHookBehavior behavior;
    @NotNull
    private final DynamicHull hull;
    private boolean hasExternalFlight;
    private boolean isFlightEnabled;
    private boolean stopFallDamage;
    private boolean isInsideHull;
    @NotNull
    private FadeTimer showHullTimer;
    private final double allowedFlightRange;
    private final double retractThreshold;
    private boolean wasFlying;

    public FlightHookPlayerController(@NotNull Player player, @NotNull FlightHookBehavior behavior) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)behavior, (String)"behavior");
        this.player = player;
        this.behavior = behavior;
        this.hull = new DynamicHull();
        this.showHullTimer = new FadeTimer();
        this.allowedFlightRange = 0.5;
        this.retractThreshold = Math.cos(Math.toRadians(15.0));
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final FlightHookBehavior getBehavior() {
        return this.behavior;
    }

    @NotNull
    public final DynamicHull getHull() {
        return this.hull;
    }

    public final boolean getHasExternalFlight() {
        return this.hasExternalFlight;
    }

    public final void setHasExternalFlight(boolean bl) {
        this.hasExternalFlight = bl;
    }

    public final boolean isFlightEnabled() {
        return this.isFlightEnabled;
    }

    public final void setFlightEnabled(boolean bl) {
        this.isFlightEnabled = bl;
    }

    public final boolean getStopFallDamage() {
        return this.stopFallDamage;
    }

    public final void setStopFallDamage(boolean bl) {
        this.stopFallDamage = bl;
    }

    public final boolean isInsideHull() {
        return this.isInsideHull;
    }

    public final void setInsideHull(boolean bl) {
        this.isInsideHull = bl;
    }

    @NotNull
    public final FadeTimer getShowHullTimer() {
        return this.showHullTimer;
    }

    public final void setShowHullTimer(@NotNull FadeTimer fadeTimer) {
        Intrinsics.checkNotNullParameter((Object)fadeTimer, (String)"<set-?>");
        this.showHullTimer = fadeTimer;
    }

    @Override
    public void saveState(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.putBoolean("HasExternalFlight", this.hasExternalFlight);
        tag.putBoolean("IsFlightEnabled", this.isFlightEnabled);
        tag.putBoolean("StopFallDamage", this.stopFallDamage);
    }

    @Override
    public void loadState(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.hasExternalFlight = tag.getBoolean("HasExternalFlight");
        this.isFlightEnabled = tag.getBoolean("IsFlightEnabled");
        this.stopFallDamage = tag.getBoolean("StopFallDamage");
    }

    @Override
    protected void writeSyncState(@NotNull FriendlyByteBuf buf, boolean initial) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeBoolean(this.hasExternalFlight);
        buf.writeBoolean(this.stopFallDamage);
        if (initial) {
            buf.writeBoolean(this.isFlightEnabled);
        }
    }

    @Override
    protected void readSyncState(@NotNull FriendlyByteBuf buf, boolean initial) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.hasExternalFlight = buf.readBoolean();
        this.stopFallDamage = buf.readBoolean();
        if (initial) {
            this.isFlightEnabled = buf.readBoolean();
        }
    }

    @Override
    public void remove() {
        this.disableFlight();
    }

    private final boolean isPointingAtHook(Vec3 pos, Vec3 direction, double cosThreshold, Hook hook) {
        Vec3 vec3 = Vec3dKt.minus((Vec3)hook.getPos(), (Vec3)pos).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        return Vec3dKt.dot((Vec3)direction, (Vec3)vec3) > cosThreshold;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fireHooks(@NotNull HookControllerDelegate delegate, @NotNull Vec3 pos, float pitch, float yaw, boolean sneaking) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (sneaking) {
            Hook closestHook;
            Object v1;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Vec3 direction = Vec3.directionFromRotation((float)pitch, (float)yaw);
            Iterable iterable = delegate.getHooks();
            boolean $i$f$map = false;
            void var11_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void hook;
                Hook hook2 = (Hook)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)direction);
                Vec3 vec3 = Vec3dKt.minus((Vec3)hook.getPos(), (Vec3)pos).normalize();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
                collection.add(TuplesKt.to((Object)hook, (Object)Vec3dKt.dot((Vec3)direction, (Vec3)vec3)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getSecond()).doubleValue() > this.retractThreshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Pair it = (Pair)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = ((Number)it.getSecond()).doubleValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-maxByOrNull-FlightHookPlayerController$fireHooks$closestHook$3 = false;
                        double v$iv = ((Number)it2.getSecond()).doubleValue();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Pair pair = v1;
            Hook hook = closestHook = pair != null ? (Hook)pair.getFirst() : null;
            if (closestHook != null) {
                HookControllerDelegate.retractHook$default(delegate, closestHook, false, 2, null);
            }
        } else if (delegate.getCooldown() == 0) {
            HookControllerDelegate.fireHook$default(delegate, pos, pitch, yaw, null, 8, null);
            delegate.triggerCooldown();
        }
    }

    @Override
    public void jump(@NotNull HookControllerDelegate delegate, boolean doubleJump, boolean sneaking) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        if (doubleJump && sneaking) {
            for (Hook hook : delegate.getHooks()) {
                HookControllerDelegate.retractHook$default(delegate, hook, false, 2, null);
            }
        }
        if (doubleJump) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = delegate.getHooks();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Hook it = (Hook)element$iv;
                        boolean bl2 = false;
                        if (!(it.getState() == Hook.State.PLANTED)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                boolean allowFlight;
                Vec3 waist = MiscUtilsKt.getWaistPos(this.player);
                ConstraintResult constrained = this.hull.constrain(waist);
                boolean bl3 = allowFlight = constrained.getDistanceOutside() < this.allowedFlightRange;
                if (!allowFlight) {
                    this.showHullTimer.start(20);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull HookControllerDelegate delegate) {
        Vec3 waist;
        ConstraintResult constrained;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Hook it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.showHullTimer.tick();
        this.fixExternalFlight();
        if (this.stopFallDamage) {
            this.player.fallDistance = 0.0f;
        }
        if (this.player.onGround()) {
            this.stopFallDamage = false;
        }
        Iterable $this$filter$iv = delegate.getHooks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Hook)element$iv$iv;
            boolean bl = false;
            if (!(it.getState() == Hook.State.PLANTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List planted = (List)destination$iv$iv;
        if (planted.size() < 2) {
            this.disableFlight();
            this.isInsideHull = false;
            return;
        }
        $this$filter$iv = planted;
        DynamicHull dynamicHull = this.hull;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Hook)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPos());
        }
        if (dynamicHull.update((List)destination$iv$iv)) {
            this.showHullTimer.start(20);
        }
        this.isInsideHull = (constrained = this.hull.constrain(waist = MiscUtilsKt.getWaistPos(this.player))).getDistanceOutside() < this.allowedFlightRange;
        this.updateFlightEnabled();
        if (this.player.getAbilities().flying && !Intrinsics.areEqual((Object)waist, (Object)constrained.getPosition())) {
            HookPlayerController.applyRestoringForce$default(this, this.player, MiscUtilsKt.fromWaistPos(this.player, constrained.getPosition()), 2.0, 2.0, 0.0, 0.0, false, 48, null);
            if (!Intrinsics.areEqual((Object)constrained.getNormal(), (Object)Vec3.ZERO)) {
                Vec3 vec3 = constrained.getPosition();
                Vec3 vec32 = this.player.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getPos(...)");
                if (Vec3dKt.minus((Vec3)vec3, (Vec3)vec32).length() < 2.0) {
                    iterable = this.player;
                    Vec3 vec33 = iterable.getDeltaMovement();
                    Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getVelocity(...)");
                    Vec3 vec34 = constrained.getNormal();
                    Vec3 vec35 = this.player.getDeltaMovement();
                    Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"getVelocity(...)");
                    iterable.setDeltaMovement(Vec3dKt.minus((Vec3)vec33, (Vec3)Vec3dKt.times((Vec3)vec34, (double)Vec3dKt.dot((Vec3)vec35, (Vec3)constrained.getNormal()))));
                }
            }
            this.showHullTimer.start(10);
        }
    }

    private final void updateFlightEnabled() {
        if (this.wasFlying && !this.player.getAbilities().flying) {
            this.stopFallDamage = true;
        }
        this.wasFlying = this.player.getAbilities().flying;
        if (!this.player.getAbilities().flying) {
            if (this.isInsideHull != this.isFlightEnabled) {
                this.showHullTimer.start(10);
            }
            if (this.isInsideHull) {
                this.enableFlight();
            } else {
                this.disableFlight();
            }
        }
    }

    @Override
    public double modifyHookRange(double baseRange, @NotNull Hook hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        if (hook.getState() == Hook.State.PLANTED) {
            return baseRange * this.behavior.getBreakRangeFactor();
        }
        return baseRange;
    }

    @Override
    public boolean isActive(@NotNull HookControllerDelegate delegate, @NotNull HookActiveReason reason) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        return switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
            case 1 -> false;
            case 2 -> false;
            case 3 -> false;
            default -> this.isInsideHull;
        };
    }

    private final void updatePlayerAbilities(Function1<? super Abilities, Unit> fn) {
        if (!this.player.level().isClientSide) {
            Abilities abilities = this.player.getAbilities();
            Intrinsics.checkNotNullExpressionValue((Object)abilities, (String)"getAbilities(...)");
            fn.invoke((Object)abilities);
            this.player.onUpdateAbilities();
        }
    }

    protected final void enableFlight() {
        if (!this.isFlightEnabled) {
            this.hasExternalFlight = this.player.getAbilities().mayfly;
            this.updatePlayerAbilities((Function1<? super Abilities, Unit>)((Function1)FlightHookPlayerController::enableFlight$lambda$6));
            this.isFlightEnabled = true;
        }
    }

    protected final void disableFlight() {
        if (this.isFlightEnabled) {
            this.updatePlayerAbilities((Function1<? super Abilities, Unit>)((Function1)arg_0 -> FlightHookPlayerController.disableFlight$lambda$7(this, arg_0)));
            this.isFlightEnabled = false;
        }
    }

    protected final void fixExternalFlight() {
        if (!this.isFlightEnabled) {
            return;
        }
        if (!this.player.getAbilities().mayfly) {
            this.hasExternalFlight = false;
            this.updatePlayerAbilities((Function1<? super Abilities, Unit>)((Function1)FlightHookPlayerController::fixExternalFlight$lambda$8));
        }
    }

    private static final Unit enableFlight$lambda$6(Abilities $this$updatePlayerAbilities) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePlayerAbilities, (String)"$this$updatePlayerAbilities");
        $this$updatePlayerAbilities.mayfly = true;
        return Unit.INSTANCE;
    }

    private static final Unit disableFlight$lambda$7(FlightHookPlayerController this$0, Abilities $this$updatePlayerAbilities) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePlayerAbilities, (String)"$this$updatePlayerAbilities");
        $this$updatePlayerAbilities.mayfly = this$0.hasExternalFlight;
        $this$updatePlayerAbilities.flying = false;
        return Unit.INSTANCE;
    }

    private static final Unit fixExternalFlight$lambda$8(Abilities $this$updatePlayerAbilities) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePlayerAbilities, (String)"$this$updatePlayerAbilities");
        $this$updatePlayerAbilities.mayfly = true;
        $this$updatePlayerAbilities.flying = true;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HookActiveReason.values().length];
            try {
                nArray[HookActiveReason.DISABLE_CLIP_AT_LEDGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookActiveReason.DISABLE_AUTO_JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookActiveReason.MOVED_WRONGLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

