/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.hooks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.client.renderer.SimpleHookRenderer;
import dev.thecodewarrior.hooked.hooks.FlightHookPlayerController;
import dev.thecodewarrior.hooked.util.ClientUtilsKt;
import dev.thecodewarrior.hooked.util.MiscUtilsKt;
import dev.thecodewarrior.hooked.util.WireframeEdge;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J?\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/thecodewarrior/hooked/hooks/FlightHookRenderer;", "Ldev/thecodewarrior/hooked/client/renderer/SimpleHookRenderer;", "Ldev/thecodewarrior/hooked/hooks/FlightHookPlayerController;", "<init>", "()V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/client/renderer/MultiBufferSource;", "consumers", "", "tickDelta", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "data", "controller", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/client/renderer/MultiBufferSource;FLdev/thecodewarrior/hooked/capability/HookedPlayerData;Ldev/thecodewarrior/hooked/hooks/FlightHookPlayerController;)V", "Ljava/awt/Color;", "color", "drawWireframe", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Ldev/thecodewarrior/hooked/hooks/FlightHookPlayerController;Ljava/awt/Color;)V", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nFlightHookRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlightHookRenderer.kt\ndev/thecodewarrior/hooked/hooks/FlightHookRenderer\n+ 2 BufferBuilder.kt\ncom/teamwizardry/librarianlib/core/util/kotlin/BufferBuilderKt\n*L\n1#1,58:1\n21#2:59\n21#2:60\n*S KotlinDebug\n*F\n+ 1 FlightHookRenderer.kt\ndev/thecodewarrior/hooked/hooks/FlightHookRenderer\n*L\n54#1:59\n55#1:60\n*E\n"})
public class FlightHookRenderer
extends SimpleHookRenderer<FlightHookPlayerController> {
    @Override
    public void render(@NotNull PoseStack matrices, @NotNull Player player, @NotNull MultiBufferSource consumers, float tickDelta, @NotNull HookedPlayerData data, @NotNull FlightHookPlayerController controller) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)consumers, (String)"consumers");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Vec3 waist = MiscUtilsKt.getWaistPos(player, tickDelta);
        matrices.pushPose();
        matrices.translate(waist.x, waist.y, waist.z);
        this.renderHooks(matrices, player, consumers, tickDelta, data);
        matrices.popPose();
        if (!(controller.getShowHullTimer().getValue() == 0.0)) {
            float alpha = (float)controller.getShowHullTimer().getValue();
            Vector3f wireframeColor = controller.getBehavior().getWireframeColor();
            this.drawWireframe(matrices, consumers, controller, new Color(wireframeColor.x, wireframeColor.y, wireframeColor.z, alpha));
        }
    }

    public final void drawWireframe(@NotNull PoseStack matrices, @NotNull MultiBufferSource consumers, @NotNull FlightHookPlayerController controller, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)consumers, (String)"consumers");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        VertexConsumer consumer = consumers.getBuffer(RenderType.lines());
        for (WireframeEdge edge : controller.getHull().getShape().getWireframe()) {
            Vec3 normal = Vec3dKt.minus((Vec3)edge.getB(), (Vec3)edge.getA()).normalize();
            Intrinsics.checkNotNull((Object)consumer);
            VertexConsumer $this$color$iv = ClientUtilsKt.vertex(consumer, matrices, edge.getA());
            boolean $i$f$color = false;
            VertexConsumer vertexConsumer = $this$color$iv.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            if (vertexConsumer == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.client.render.VertexConsumer");
            }
            Intrinsics.checkNotNull((Object)normal);
            ClientUtilsKt.normal(vertexConsumer, matrices, normal);
            $this$color$iv = ClientUtilsKt.vertex(consumer, matrices, edge.getB());
            $i$f$color = false;
            VertexConsumer vertexConsumer2 = $this$color$iv.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            if (vertexConsumer2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.client.render.VertexConsumer");
            }
            ClientUtilsKt.normal(vertexConsumer2, matrices, normal);
        }
    }
}

