/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.neoforge;

import dev.thecodewarrior.hooked.HookedCommon;
import dev.thecodewarrior.hooked.bridge.PlayerMixinBridgeKt;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.neoforge.HookedPlayerDataAttachment;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="hooked")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Ldev/thecodewarrior/hooked/neoforge/HookedNeoForgeCommon;", "", "Lnet/neoforged/bus/api/IEventBus;", "modEventBus", "<init>", "(Lnet/neoforged/bus/api/IEventBus;)V", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$BreakSpeed;", "event", "", "breakSpeedEvent", "(Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$BreakSpeed;)V", "Companion", "hooked-neoforge"})
public final class HookedNeoForgeCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    @NotNull
    private static final DeferredRegister<GameEvent> GAME_EVENTS;
    @NotNull
    private static final Supplier<AttachmentType<HookedPlayerDataAttachment>> HOOK_DATA;

    public HookedNeoForgeCommon(@NotNull IEventBus modEventBus) {
        Intrinsics.checkNotNullParameter((Object)modEventBus, (String)"modEventBus");
        HookedCommon.INSTANCE.init();
        ATTACHMENT_TYPES.register(modEventBus);
        GAME_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void breakSpeedEvent(@NotNull PlayerEvent.BreakSpeed event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        if (PlayerMixinBridgeKt.bridge(player).isHookActive(HookActiveReason.BREAK_SPEED)) {
            if (event.getEntity().isEyeInFluid(FluidTags.WATER)) {
                AttributeInstance attributeInstance = event.getEntity().getAttribute(Attributes.SUBMERGED_MINING_SPEED);
                Intrinsics.checkNotNull((Object)attributeInstance);
                double submergedSpeed = attributeInstance.getValue();
                if (submergedSpeed > 0.0) {
                    event.setNewSpeed(event.getNewSpeed() / (float)submergedSpeed);
                }
            }
            if (!event.getEntity().onGround()) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
        }
    }

    private static final HookedPlayerDataAttachment HOOK_DATA$lambda$1$lambda$0(IAttachmentHolder holder) {
        Intrinsics.checkNotNull((Object)holder, (String)"null cannot be cast to non-null type net.minecraft.entity.player.PlayerEntity");
        return new HookedPlayerDataAttachment((Player)holder);
    }

    private static final AttachmentType HOOK_DATA$lambda$1() {
        return AttachmentType.serializable(HookedNeoForgeCommon::HOOK_DATA$lambda$1$lambda$0).build();
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"hooked");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        ATTACHMENT_TYPES = deferredRegister;
        DeferredRegister deferredRegister2 = DeferredRegister.create((Registry)((Registry)BuiltInRegistries.GAME_EVENT), (String)"hooked");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister2, (String)"create(...)");
        GAME_EVENTS = deferredRegister2;
        DeferredHolder deferredHolder = ATTACHMENT_TYPES.register("hook_data", HookedNeoForgeCommon::HOOK_DATA$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder, (String)"register(...)");
        HOOK_DATA = (Supplier)deferredHolder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\tR#\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\r8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ldev/thecodewarrior/hooked/neoforge/HookedNeoForgeCommon$Companion;", "", "<init>", "()V", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "Lnet/neoforged/neoforge/attachment/AttachmentType;", "ATTACHMENT_TYPES", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "getATTACHMENT_TYPES", "()Lnet/neoforged/neoforge/registries/DeferredRegister;", "Lnet/minecraft/world/level/gameevent/GameEvent;", "GAME_EVENTS", "getGAME_EVENTS", "Ljava/util/function/Supplier;", "Ldev/thecodewarrior/hooked/neoforge/HookedPlayerDataAttachment;", "HOOK_DATA", "Ljava/util/function/Supplier;", "getHOOK_DATA", "()Ljava/util/function/Supplier;", "hooked-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeferredRegister<AttachmentType<?>> getATTACHMENT_TYPES() {
            return ATTACHMENT_TYPES;
        }

        @NotNull
        public final DeferredRegister<GameEvent> getGAME_EVENTS() {
            return GAME_EVENTS;
        }

        @NotNull
        public final Supplier<AttachmentType<HookedPlayerDataAttachment>> getHOOK_DATA() {
            return HOOK_DATA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

