/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.neoforge.platform;

import com.google.auto.service.AutoService;
import dev.architectury.networking.NetworkManager;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.item.HookProperties;
import dev.thecodewarrior.hooked.neoforge.HookItemNeoForge;
import dev.thecodewarrior.hooked.neoforge.HookedNeoForgeCommon;
import dev.thecodewarrior.hooked.neoforge.HookedPlayerDataAttachment;
import dev.thecodewarrior.hooked.platform.HookedPlatformCommon;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJC\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\"\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J+\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0(2\u0006\u0010%\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0&H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u0002002\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b1\u00102J%\u00108\u001a\u00020\u00192\u0006\u00104\u001a\u0002032\f\u00107\u001a\b\u0012\u0004\u0012\u00020605H\u0016\u00a2\u0006\u0004\b8\u00109\u00a8\u0006:"}, d2={"Ldev/thecodewarrior/hooked/neoforge/platform/HookedPlatformCommonNeoForge;", "Ldev/thecodewarrior/hooked/platform/HookedPlatformCommon;", "<init>", "()V", "Lnet/minecraft/world/item/Item$Properties;", "settings", "Lnet/minecraft/world/item/Item;", "createHookItem", "(Lnet/minecraft/world/item/Item$Properties;)Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/level/GameRules$Value;", "T", "", "name", "Lnet/minecraft/world/level/GameRules$Category;", "category", "Lnet/minecraft/world/level/GameRules$Type;", "type", "Lnet/minecraft/world/level/GameRules$Key;", "registerGameRule", "(Ljava/lang/String;Lnet/minecraft/world/level/GameRules$Category;Lnet/minecraft/world/level/GameRules$Type;)Lnet/minecraft/world/level/GameRules$Key;", "", "defaultValue", "Lkotlin/Function2;", "Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/world/level/GameRules$BooleanValue;", "", "changedCallback", "createBooleanGameRule", "(ZLkotlin/jvm/functions/Function2;)Lnet/minecraft/world/level/GameRules$Type;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/gameevent/GameEvent;", "event", "", "frequency", "registerVibrationFrequencyFabric", "(Lnet/minecraft/resources/ResourceKey;I)V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lkotlin/Function0;", "supplier", "Lnet/minecraft/core/Holder;", "registerGameEvent", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function0;)Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/entity/player/Player;", "player", "Ldev/thecodewarrior/hooked/item/HookProperties;", "getEquippedHook", "(Lnet/minecraft/world/entity/player/Player;)Ldev/thecodewarrior/hooked/item/HookProperties;", "Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "getHookedPlayerData", "(Lnet/minecraft/world/entity/player/Player;)Ldev/thecodewarrior/hooked/capability/HookedPlayerData;", "Lnet/minecraft/world/entity/Entity;", "target", "", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "packets", "sendToPlayersTrackingEntity", "(Lnet/minecraft/world/entity/Entity;Ljava/util/List;)V", "hooked-neoforge"})
@AutoService(value={HookedPlatformCommon.class})
public final class HookedPlatformCommonNeoForge
implements HookedPlatformCommon {
    @Override
    @NotNull
    public Item createHookItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new HookItemNeoForge(settings);
    }

    @Override
    @NotNull
    public <T extends GameRules.Value<T>> GameRules.Key<T> registerGameRule(@NotNull String name, @NotNull GameRules.Category category, @NotNull GameRules.Type<T> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        GameRules.Key key = GameRules.register((String)name, (GameRules.Category)category, type);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"register(...)");
        return key;
    }

    @Override
    @NotNull
    public GameRules.Type<GameRules.BooleanValue> createBooleanGameRule(boolean defaultValue, @NotNull Function2<? super MinecraftServer, ? super GameRules.BooleanValue, Unit> changedCallback) {
        Intrinsics.checkNotNullParameter(changedCallback, (String)"changedCallback");
        GameRules.Type type = GameRules.BooleanValue.create((boolean)defaultValue, (arg_0, arg_1) -> HookedPlatformCommonNeoForge.createBooleanGameRule$lambda$0(changedCallback, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"create(...)");
        return type;
    }

    @Override
    public void registerVibrationFrequencyFabric(@NotNull ResourceKey<GameEvent> event, int frequency) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
    }

    @Override
    @NotNull
    public Holder<GameEvent> registerGameEvent(@NotNull ResourceLocation id, @NotNull Function0<GameEvent> supplier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        DeferredHolder deferredHolder = HookedNeoForgeCommon.Companion.getGAME_EVENTS().register(id.getPath(), () -> HookedPlatformCommonNeoForge.registerGameEvent$lambda$1(supplier));
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder, (String)"register(...)");
        return (Holder)deferredHolder;
    }

    @Override
    @Nullable
    public HookProperties getEquippedHook(@NotNull Player player) {
        HookProperties hookProperties;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)player));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getCuriosInventory(...)");
            ICuriosItemHandler iCuriosItemHandler = (ICuriosItemHandler)OptionalsKt.getOrNull((Optional)optional);
            if (iCuriosItemHandler == null) {
                return null;
            }
            ICuriosItemHandler curiosInventory = iCuriosItemHandler;
            Optional optional2 = curiosInventory.getStacksHandler("hooked_hook");
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getStacksHandler(...)");
            ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)OptionalsKt.getOrNull((Optional)optional2);
            if (iCurioStacksHandler == null) {
                return null;
            }
            ICurioStacksHandler slotHandler = iCurioStacksHandler;
            Iterator iterator2 = ((Iterable)RangesKt.until((int)0, (int)slotHandler.getStacks().getSlots())).iterator();
            while (iterator2.hasNext()) {
                int i = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                ItemStack itemStack = slotHandler.getStacks().getStackInSlot(i);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
                HookProperties hookProperties2 = HookProperties.Companion.fromItemStack(itemStack);
                if (hookProperties2 == null) continue;
                hookProperties = hookProperties2;
                break block3;
            }
            hookProperties = null;
        }
        return hookProperties;
    }

    @Override
    @NotNull
    public HookedPlayerData getHookedPlayerData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return ((HookedPlayerDataAttachment)player.getData(HookedNeoForgeCommon.Companion.getHOOK_DATA())).getData();
    }

    @Override
    public void sendToPlayersTrackingEntity(@NotNull Entity target, @NotNull List<? extends CustomPacketPayload> packets) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        ChunkSource chunkSource = target.level().getChunkSource();
        ServerChunkCache serverChunkCache = chunkSource instanceof ServerChunkCache ? (ServerChunkCache)chunkSource : null;
        if (serverChunkCache == null) {
            return;
        }
        ServerChunkCache chunkManager = serverChunkCache;
        for (CustomPacketPayload customPacketPayload : packets) {
            NetworkManager.collectPackets(arg_0 -> HookedPlatformCommonNeoForge.sendToPlayersTrackingEntity$lambda$3(chunkManager, target, arg_0), (NetworkManager.Side)NetworkManager.Side.S2C, (CustomPacketPayload)customPacketPayload, (RegistryAccess)target.level().registryAccess());
        }
    }

    private static final void createBooleanGameRule$lambda$0(Function2 $tmp0, MinecraftServer p0, GameRules.BooleanValue p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final GameEvent registerGameEvent$lambda$1(Function0 $tmp0) {
        return (GameEvent)$tmp0.invoke();
    }

    private static final void sendToPlayersTrackingEntity$lambda$3(ServerChunkCache $chunkManager, Entity $target, Packet it) {
        $chunkManager.broadcast($target, it);
    }
}

