/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.util;

import com.teamwizardry.librarianlib.core.util.Shorthand;
import com.teamwizardry.librarianlib.math.MathUtils;
import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.util.BoundingShape;
import dev.thecodewarrior.hooked.util.ConstraintResult;
import dev.thecodewarrior.hooked.util.WireframeEdge;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001d\u0010\fR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001bR \u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Ldev/thecodewarrior/hooked/util/LineSegment;", "Ldev/thecodewarrior/hooked/util/BoundingShape;", "Lnet/minecraft/world/phys/Vec3;", "a", "b", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "point", "Ldev/thecodewarrior/hooked/util/ConstraintResult;", "constrain", "(Lnet/minecraft/world/phys/Vec3;)Ldev/thecodewarrior/hooked/util/ConstraintResult;", "component1", "()Lnet/minecraft/world/phys/Vec3;", "component2", "copy", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Ldev/thecodewarrior/hooked/util/LineSegment;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/phys/Vec3;", "getA", "getB", "", "length", "D", "normalized", "", "Ldev/thecodewarrior/hooked/util/WireframeEdge;", "wireframe", "Ljava/util/Set;", "getWireframe", "()Ljava/util/Set;", "hooked-common"})
public final class LineSegment
implements BoundingShape {
    @NotNull
    private final Vec3 a;
    @NotNull
    private final Vec3 b;
    private final double length;
    @NotNull
    private final Vec3 normalized;
    @NotNull
    private final Set<WireframeEdge> wireframe;

    public LineSegment(@NotNull Vec3 a, @NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.a = a;
        this.b = b;
        this.length = Vec3dKt.minus((Vec3)this.b, (Vec3)this.a).length();
        this.normalized = this.length == 0.0 ? Shorthand.vec((double)0.0, (double)1.0, (double)0.0) : Vec3dKt.div((Vec3)Vec3dKt.minus((Vec3)this.b, (Vec3)this.a), (double)this.length);
        this.wireframe = SetsKt.setOf((Object)new WireframeEdge(this.a, this.b));
    }

    @NotNull
    public final Vec3 getA() {
        return this.a;
    }

    @NotNull
    public final Vec3 getB() {
        return this.b;
    }

    @Override
    @NotNull
    public Set<WireframeEdge> getWireframe() {
        return this.wireframe;
    }

    @Override
    @NotNull
    public ConstraintResult constrain(@NotNull Vec3 point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double dot = Vec3dKt.dot((Vec3)Vec3dKt.minus((Vec3)point, (Vec3)this.a), (Vec3)this.normalized);
        Vec3 newPoint = Vec3dKt.plus((Vec3)this.a, (Vec3)Vec3dKt.times((Vec3)this.normalized, (double)MathUtils.clamp((double)dot, (double)0.0, (double)this.length)));
        Vec3 vec3 = Vec3dKt.minus((Vec3)point, (Vec3)Vec3dKt.plus((Vec3)this.a, (Vec3)Vec3dKt.times((Vec3)this.normalized, (double)dot))).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        return new ConstraintResult(newPoint, vec3, point.distanceTo(newPoint));
    }

    @NotNull
    public final Vec3 component1() {
        return this.a;
    }

    @NotNull
    public final Vec3 component2() {
        return this.b;
    }

    @NotNull
    public final LineSegment copy(@NotNull Vec3 a, @NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new LineSegment(a, b);
    }

    public static /* synthetic */ LineSegment copy$default(LineSegment lineSegment, Vec3 vec3, Vec3 vec32, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = lineSegment.a;
        }
        if ((n & 2) != 0) {
            vec32 = lineSegment.b;
        }
        return lineSegment.copy(vec3, vec32);
    }

    @NotNull
    public String toString() {
        return "LineSegment(a=" + this.a + ", b=" + this.b + ")";
    }

    public int hashCode() {
        int result = this.a.hashCode();
        result = result * 31 + this.b.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LineSegment)) {
            return false;
        }
        LineSegment lineSegment = (LineSegment)other;
        if (!Intrinsics.areEqual((Object)this.a, (Object)lineSegment.a)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.b, (Object)lineSegment.b);
    }
}

