/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.util;

import com.teamwizardry.librarianlib.math.Matrix4d;
import com.teamwizardry.librarianlib.math.Vec2d;
import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.util.BoundingShape;
import dev.thecodewarrior.hooked.util.ConstraintResult;
import dev.thecodewarrior.hooked.util.LineSegment;
import dev.thecodewarrior.hooked.util.WireframeEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\bH\u0086\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J \u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b#\u0010\u0015R\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u00028\u0006\u00a2\u0006\f\n\u0004\b%\u0010\"\u001a\u0004\b&\u0010\u0015R\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u00028\u0006\u00a2\u0006\f\n\u0004\b'\u0010\"\u001a\u0004\b(\u0010\u0015R\u0017\u0010\t\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\u000b\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010*\u001a\u0004\b-\u0010,R\u0017\u0010.\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u0017\u00102\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b2\u0010/\u001a\u0004\b3\u00101R\u0017\u00104\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u0010\u001eR\u0017\u00107\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b7\u0010/\u001a\u0004\b8\u00101R\u0017\u00109\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b9\u00105\u001a\u0004\b:\u0010\u001eR\u0017\u0010;\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b;\u0010/\u001a\u0004\b<\u00101R!\u0010C\u001a\b\u0012\u0004\u0012\u00020>0=8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Ldev/thecodewarrior/hooked/util/Polygon;", "Ldev/thecodewarrior/hooked/util/BoundingShape;", "", "Lnet/minecraft/world/phys/Vec3;", "points", "<init>", "(Ljava/util/List;)V", "point", "Lcom/teamwizardry/librarianlib/math/Vec2d;", "pointToPlane", "(Lnet/minecraft/world/phys/Vec3;)Lcom/teamwizardry/librarianlib/math/Vec2d;", "planeToPoint", "(Lcom/teamwizardry/librarianlib/math/Vec2d;)Lnet/minecraft/world/phys/Vec3;", "Ldev/thecodewarrior/hooked/util/ConstraintResult;", "constrain", "(Lnet/minecraft/world/phys/Vec3;)Ldev/thecodewarrior/hooked/util/ConstraintResult;", "test", "", "contains", "(Lcom/teamwizardry/librarianlib/math/Vec2d;)Z", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Ldev/thecodewarrior/hooked/util/Polygon;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getPoints", "Ldev/thecodewarrior/hooked/util/LineSegment;", "edges", "getEdges", "points2d", "getPoints2d", "Lcom/teamwizardry/librarianlib/math/Matrix4d;", "Lcom/teamwizardry/librarianlib/math/Matrix4d;", "getPointToPlane", "()Lcom/teamwizardry/librarianlib/math/Matrix4d;", "getPlaneToPoint", "a", "Lnet/minecraft/world/phys/Vec3;", "getA", "()Lnet/minecraft/world/phys/Vec3;", "b", "getB", "bIndex", "I", "getBIndex", "c", "getC", "cIndex", "getCIndex", "normal", "getNormal", "", "Ldev/thecodewarrior/hooked/util/WireframeEdge;", "wireframe$delegate", "Lkotlin/Lazy;", "getWireframe", "()Ljava/util/Set;", "wireframe", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ndev/thecodewarrior/hooked/util/Polygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1567#2:419\n1598#2,4:420\n1557#2:424\n1628#2,3:425\n1557#2:428\n1628#2,3:429\n2318#2,14:432\n1557#2:446\n1628#2,3:447\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\ndev/thecodewarrior/hooked/util/Polygon\n*L\n293#1:419\n293#1:420,4\n305#1:424\n305#1:425,3\n330#1:428\n330#1:429,3\n330#1:432,14\n309#1:446\n309#1:447,3\n*E\n"})
public final class Polygon
implements BoundingShape {
    @NotNull
    private final List<Vec3> points;
    @NotNull
    private final List<LineSegment> edges;
    @NotNull
    private final List<Vec2d> points2d;
    @NotNull
    private final Matrix4d pointToPlane;
    @NotNull
    private final Matrix4d planeToPoint;
    @NotNull
    private final Vec3 a;
    @NotNull
    private final Vec3 b;
    private final int bIndex;
    @NotNull
    private final Vec3 c;
    private final int cIndex;
    @NotNull
    private final Vec3 normal;
    @NotNull
    private final Lazy wireframe$delegate;

    /*
     * WARNING - void declaration
     */
    public Polygon(@NotNull List<? extends Vec3> points) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.points = points;
        this.a = this.points.get(0);
        this.bIndex = Math.max(1, this.points.size() / 3);
        this.b = this.points.get(this.bIndex);
        this.cIndex = Math.min(this.points.size() - 1, this.bIndex + Math.max(1, this.points.size() / 3));
        this.c = this.points.get(this.cIndex);
        Vec3 edge1 = Vec3dKt.minus((Vec3)this.b, (Vec3)this.a);
        Vec3 edge2 = Vec3dKt.minus((Vec3)this.c, (Vec3)this.a);
        this.normal = Vec3dKt.cross((Vec3)edge1, (Vec3)edge2).normalize();
        Vec3 axis1 = edge1.normalize();
        Vec3 axis2 = Vec3dKt.cross((Vec3)edge1, (Vec3)this.normal).normalize();
        Iterable iterable = this.points;
        Polygon polygon = this;
        boolean $i$f$mapIndexed = false;
        void var8_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void i;
            void point;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vec3 vec3 = (Vec3)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LineSegment((Vec3)point, this.points.get((int)((i + true) % this.points.size()))));
        }
        polygon.edges = (List)destination$iv$iv;
        this.planeToPoint = new Matrix4d(axis1.x, axis2.x, this.normal.x, this.a.x, axis1.y, axis2.y, this.normal.y, this.a.y, axis1.z, axis2.z, this.normal.z, this.a.z, 0.0, 0.0, 0.0, 1.0);
        this.pointToPlane = this.planeToPoint.invert();
        $this$mapIndexed$iv = this.points;
        polygon = this;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Vec3)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.pointToPlane((Vec3)it));
        }
        polygon.points2d = (List)destination$iv$iv;
        this.wireframe$delegate = LazyKt.lazy(() -> Polygon.wireframe_delegate$lambda$3(this));
    }

    @NotNull
    public final List<Vec3> getPoints() {
        return this.points;
    }

    @NotNull
    public final List<LineSegment> getEdges() {
        return this.edges;
    }

    @NotNull
    public final List<Vec2d> getPoints2d() {
        return this.points2d;
    }

    @NotNull
    public final Matrix4d getPointToPlane() {
        return this.pointToPlane;
    }

    @NotNull
    public final Matrix4d getPlaneToPoint() {
        return this.planeToPoint;
    }

    @NotNull
    public final Vec3 getA() {
        return this.a;
    }

    @NotNull
    public final Vec3 getB() {
        return this.b;
    }

    public final int getBIndex() {
        return this.bIndex;
    }

    @NotNull
    public final Vec3 getC() {
        return this.c;
    }

    public final int getCIndex() {
        return this.cIndex;
    }

    @NotNull
    public final Vec3 getNormal() {
        return this.normal;
    }

    @Override
    @NotNull
    public Set<WireframeEdge> getWireframe() {
        Lazy lazy = this.wireframe$delegate;
        return (Set)lazy.getValue();
    }

    private final Vec2d pointToPlane(Vec3 point) {
        Vec3 transformed = this.pointToPlane.times(point);
        return new Vec2d(transformed.x, transformed.y);
    }

    private final Vec3 planeToPoint(Vec2d point) {
        return this.planeToPoint.times(new Vec3(point.getX(), point.getY(), 0.0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstraintResult constrain(@NotNull Vec3 point) {
        Object t;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Vec2d point2d = this.pointToPlane(point);
        if (this.contains(point2d)) {
            Vec3 constrainedPoint = this.planeToPoint(point2d);
            Vec3 delta = Vec3dKt.minus((Vec3)point, (Vec3)constrainedPoint);
            double deltaLength = delta.length();
            return new ConstraintResult(constrainedPoint, Vec3dKt.div((Vec3)delta, (double)deltaLength), deltaLength);
        }
        Iterable $this$map$iv = this.edges;
        boolean $i$f$map = false;
        Iterable deltaLength = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LineSegment lineSegment = (LineSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.constrain(point));
        }
        Iterable $this$minBy$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            ConstraintResult it = (ConstraintResult)minElem$iv;
            boolean bl = false;
            double minValue$iv = it.getDistanceOutside();
            do {
                Object e$iv = iterator$iv.next();
                ConstraintResult it2 = (ConstraintResult)e$iv;
                $i$a$-minByOrThrow-Polygon$constrain$2 = false;
                double v$iv = it2.getDistanceOutside();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        return (ConstraintResult)t;
    }

    public final boolean contains(@NotNull Vec2d test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        int i = 0;
        int j = this.points2d.size() - 1;
        boolean result = false;
        while (i < this.points2d.size()) {
            if (this.points2d.get(i).getY() > test.getY() != this.points2d.get(j).getY() > test.getY() && test.getX() < (this.points2d.get(j).getX() - this.points2d.get(i).getX()) * (test.getY() - this.points2d.get(i).getY()) / (this.points2d.get(j).getY() - this.points2d.get(i).getY()) + this.points2d.get(i).getX()) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    @NotNull
    public final List<Vec3> component1() {
        return this.points;
    }

    @NotNull
    public final Polygon copy(@NotNull List<? extends Vec3> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        return new Polygon(points);
    }

    public static /* synthetic */ Polygon copy$default(Polygon polygon, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = polygon.points;
        }
        return polygon.copy(list);
    }

    @NotNull
    public String toString() {
        return "Polygon(points=" + this.points + ")";
    }

    public int hashCode() {
        return ((Object)this.points).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Polygon)) {
            return false;
        }
        Polygon polygon = (Polygon)other;
        return Intrinsics.areEqual(this.points, polygon.points);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set wireframe_delegate$lambda$3(Polygon this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.edges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LineSegment lineSegment = (LineSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WireframeEdge(it.getA(), it.getB()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

