/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.api.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.iglee42.igleelib.IgleeLibrary;
import fr.iglee42.igleelib.api.utils.DefaultParameter;
import fr.iglee42.igleelib.api.utils.ModsUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class JsonHelper {
    public static boolean getBoolean(JsonObject json, String name) {
        return json.get(name).getAsBoolean();
    }

    public static String getString(JsonObject json, String name) {
        return json.get(name).getAsString();
    }

    public static int getInt(JsonObject json, String name) {
        return json.get(name).getAsInt();
    }

    public static Item getItem(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static Block getBlock(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static EntityType<?> getEntityType(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static boolean getBooleanOrDefault(JsonObject json, String name, boolean def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsBoolean();
    }

    public static String getStringOrDefault(JsonObject json, String name, String def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsString();
    }

    public static int getIntOrDefault(JsonObject json, String name, int def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsInt();
    }

    public static Item getItemOrDefault(JsonObject json, String name, Item def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static Block getBlockOrDefault(JsonObject json, String name, Block def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static EntityType<?> getEntityTypeOrDefault(JsonObject json, String name, EntityType<?> def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)it[0], (String)it[1]));
    }

    public static <O extends Record, T, J extends JsonElement> O createRecordFromJson(Class<O> recordClass, JsonObject json) {
        try {
            ArrayList<Object> args = new ArrayList<Object>();
            ArrayList classes = new ArrayList();
            for (RecordComponent component : recordClass.getRecordComponents()) {
                if (Integer.class.equals(component.getType()) || Integer.TYPE.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getIntOrDefault(json, component.getName(), component.getAnnotation(DefaultParameter.class).intValue()));
                    } else {
                        args.add(JsonHelper.getInt(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (String.class.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getStringOrDefault(json, component.getName(), component.getAnnotation(DefaultParameter.class).stringValue()));
                    } else {
                        args.add(JsonHelper.getString(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (Boolean.class.equals(component.getType()) || Boolean.TYPE.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getBooleanOrDefault(json, component.getName(), component.getAnnotation(DefaultParameter.class).booleanValue()));
                    } else {
                        args.add(JsonHelper.getBoolean(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (Item.class.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getItemOrDefault(json, component.getName(), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)component.getAnnotation(DefaultParameter.class).itemValue()))));
                    } else {
                        args.add(JsonHelper.getItem(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (Block.class.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getBlockOrDefault(json, component.getName(), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)component.getAnnotation(DefaultParameter.class).blockValue()))));
                    } else {
                        args.add(JsonHelper.getBlock(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (EntityType.class.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getEntityTypeOrDefault(json, component.getName(), (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)component.getAnnotation(DefaultParameter.class).entityTypeValue()))));
                    } else {
                        args.add(JsonHelper.getEntityType(json, component.getName()));
                    }
                    classes.add(component.getType());
                    continue;
                }
                if (ResourceLocation.class.equals(component.getType())) {
                    if (component.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(ResourceLocation.tryParse((String)JsonHelper.getStringOrDefault(json, component.getName(), component.getAnnotation(DefaultParameter.class).stringValue())));
                    } else {
                        args.add(ResourceLocation.tryParse((String)JsonHelper.getString(json, component.getName())));
                    }
                    classes.add(component.getType());
                    continue;
                }
                Function parser = IgleeLibrary.getClassParser(component.getType());
                args.add(parser.apply(json.get(component.getName())));
                classes.add(component.getType());
            }
            return (O)((Record)recordClass.getConstructor(classes.toArray(new Class[0])).newInstance(args.toArray(new Object[0])));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

