/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.common.baseutils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.iglee42.igleelib.common.baseutils.LiquidBlockVertexConsumer;
import fr.iglee42.igleelib.mixins.AccessorMultiBufferSource;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SequencedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GhostBlock {
    private BlockPos pos;
    private BlockState state;
    private int time;

    public GhostBlock(BlockPos pos, BlockState state, int time) {
        this.pos = pos;
        this.state = state;
        this.time = time;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public int getTime() {
        return this.time;
    }

    private void renderBlock(PoseStack matrix, MultiBufferSource.BufferSource buffers, boolean shouldTranslate) {
        if (this.state.liquid()) {
            matrix.pushPose();
            if (shouldTranslate) {
                matrix.translate((float)this.pos.getX(), (float)this.pos.getY(), (float)this.pos.getZ());
            }
            matrix.translate(0.0f, 0.125f, 0.0f);
            Lighting.setupForFlatItems();
            if (!this.state.getFluidState().isEmpty() && Minecraft.getInstance().level != null) {
                Minecraft.getInstance().getBlockRenderer().renderLiquid(this.pos, (BlockAndTintGetter)Minecraft.getInstance().level, (VertexConsumer)new LiquidBlockVertexConsumer(buffers.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)this.state.getFluidState())), matrix, this.pos), this.state, this.state.getFluidState());
            }
            matrix.popPose();
            return;
        }
        if (this.state.getRenderShape() == RenderShape.MODEL) {
            if (shouldTranslate) {
                matrix.translate((float)this.pos.getX(), (float)this.pos.getY(), (float)this.pos.getZ());
            }
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = blockRenderer.getBlockModel(this.state);
            for (RenderType layer : model.getRenderTypes(this.state, Minecraft.getInstance().level.random, ModelData.EMPTY)) {
                matrix.pushPose();
                Lighting.setupForFlatItems();
                blockRenderer.renderSingleBlock(this.state, matrix, (MultiBufferSource)buffers, 192, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, layer);
                if (!this.state.getFluidState().isEmpty() && Minecraft.getInstance().level != null) {
                    matrix.translate(0.0f, 0.125f, 0.0f);
                    Minecraft.getInstance().getBlockRenderer().renderLiquid(this.pos, (BlockAndTintGetter)Minecraft.getInstance().level, (VertexConsumer)new LiquidBlockVertexConsumer(buffers.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)this.state.getFluidState())), matrix, this.pos), this.state, this.state.getFluidState());
                }
                matrix.popPose();
            }
        }
    }

    public void render(PoseStack stack) {
        Vec3 renderView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        stack.pushPose();
        stack.translate(-renderView.x, -renderView.y, -renderView.z);
        stack.translate((float)this.pos.getX(), (float)this.pos.getY(), (float)this.pos.getZ());
        MultiBufferSource.BufferSource buffers = GhostBlock.initBuffers(Minecraft.getInstance().renderBuffers().bufferSource());
        this.renderBlock(stack, buffers, false);
        buffers.endBatch();
        stack.popPose();
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        ByteBufferBuilder fallback = ((AccessorMultiBufferSource)original).getFallbackBuffer();
        SequencedMap<RenderType, ByteBufferBuilder> layerBuffers = ((AccessorMultiBufferSource)original).getFixedBuffers();
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderLayer.remap((RenderType)e.getKey()), (ByteBufferBuilder)e.getValue());
        }
        return new GhostBuffers(fallback, (SequencedMap<RenderType, ByteBufferBuilder>)remapped);
    }

    public boolean tick() {
        if (this.time == 0) {
            return true;
        }
        if (this.time > 0) {
            --this.time;
        }
        return false;
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "igleelib"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> {
                original.setupRenderState();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                original.clearRenderState();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        protected GhostBuffers(ByteBufferBuilder fallback, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer getBuffer(RenderType type) {
            return super.getBuffer(GhostRenderLayer.remap(type));
        }
    }
}

