/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class GyrodyneEntity
extends Rotorcraft {
    @Override
    public EngineVehicle.GUI_STYLE getGuiStyle() {
        return EngineVehicle.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, false);
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    public Item asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected double getDefaultGravity() {
        return (double)(1.0f - this.getEnginePower()) * super.getDefaultGravity();
    }

    private void updateEnginePowerTooltip() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.level().isClientSide && (double)this.getFuelUtilization() > 0.0) {
                player.displayClientMessage((Component)Component.translatable((String)"immersive_aircraft.gyrodyne_target", (Object[])new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
            }
        }
    }

    @Override
    public String getFuelType() {
        return "fat";
    }

    @Override
    public boolean isFuelLow() {
        return false;
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0) {
                LivingEntity livingEntity = this.getControllingPassenger();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"immersive_aircraft.gyrodyne_target_reached"), true);
                }
                if (this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.25, 0.0));
                }
            }
        }
        float power = this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth();
        Vector3f f = this.getTopDirection().mul(power);
        this.setDeltaMovement(this.getDeltaMovement().add((double)f.x, (double)f.y, (double)f.z));
        Vector3f direction = this.getForwardDirection();
        float sin = Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED)) * sin;
        if (this.onGround() && (double)this.getEngineTarget() < 1.0) {
            thrust = this.getProperties().get(VehicleStat.PUSH_SPEED) / (1.0f + (float)this.getDeltaMovement().length() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        Vector3f f2 = direction.mul(thrust);
        this.setDeltaMovement(this.getDeltaMovement().add((double)f2.x, (double)f2.y, (double)f2.z));
    }

    @Override
    public void tick() {
        super.tick();
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            float consumption = this.getFuelConsumption() * 0.025f;
            player.causeFoodExhaustion(consumption);
        }
    }

    @Override
    public float getFuelUtilization() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.getFoodData().getFoodLevel() > 5) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public double getZoom() {
        return 2.0;
    }
}

