/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.api.SoundEffect;
import toni.immersivemessages.api.TextAnchor;
import toni.immersivemessages.util.ImmersiveColor;

public class ImmersiveMessagesCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"immersivemessages").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"popup").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"subtitle", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"player");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String title = StringArgumentType.getString((CommandContext)context, (String)"title");
            String subtitle = StringArgumentType.getString((CommandContext)context, (String)"subtitle");
            ImmersiveMessage.popup(duration, title, subtitle).sendServer(players);
            return 1;
        }))))))).then(Commands.literal((String)"toast").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"subtitle", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"player");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String title = StringArgumentType.getString((CommandContext)context, (String)"title");
            String subtitle = StringArgumentType.getString((CommandContext)context, (String)"subtitle");
            ImmersiveMessage.toast(duration, title, subtitle).sendServer(players);
            return 1;
        }))))))).then(Commands.literal((String)"send").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"player");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String string = StringArgumentType.getString((CommandContext)context, (String)"string");
            ImmersiveMessage.builder(duration, string).slideUp().typewriter(1.0f, false).sound(SoundEffect.LOWSHORT).fadeIn().fadeOut().sendServer(players);
            return 1;
        })))))).then(Commands.literal((String)"sendcustom").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"data", (ArgumentType)CompoundTagArgument.compoundTag()).then(Commands.argument((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"player");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            CompoundTag data = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"data");
            String string = StringArgumentType.getString((CommandContext)context, (String)"string");
            ImmersiveMessage tooltip = ImmersiveMessage.builder(duration, string);
            tooltip.y(0.0f);
            tooltip.animation.withYPosition(0.0f);
            if (data.contains("fadein")) {
                tooltip.fadeIn(data.getFloat("fadein"));
            } else if (data.contains("fadeout")) {
                tooltip.fadeOut(data.getFloat("fadeout"));
            } else {
                tooltip.fadeIn().fadeOut();
            }
            if (data.contains("typewriter")) {
                tooltip.typewriter(1.0f, false);
            }
            if (data.contains("sound")) {
                tooltip.sound(SoundEffect.LOWSHORT);
            }
            if (data.contains("bold")) {
                tooltip.bold();
            }
            if (data.contains("italic")) {
                tooltip.italic();
            }
            if (data.contains("wrap")) {
                tooltip.wrap(0);
            }
            if (data.contains("background")) {
                tooltip.background();
            }
            if (data.contains("bgColor")) {
                tooltip.backgroundColor(new ImmersiveColor(((TextColor)TextColor.parseColor((String)data.getString("bgColor")).getOrThrow()).getValue()));
            }
            if (data.contains("borderTop")) {
                tooltip.backgroundColor(new ImmersiveColor(((TextColor)TextColor.parseColor((String)data.getString("borderTop")).getOrThrow()).getValue()));
            }
            if (data.contains("borderBottom")) {
                tooltip.backgroundColor(new ImmersiveColor(((TextColor)TextColor.parseColor((String)data.getString("borderBottom")).getOrThrow()).getValue()));
            }
            if (data.contains("rainbow")) {
                tooltip.rainbow();
            }
            if (data.contains("shake")) {
                tooltip.shake();
            }
            if (data.contains("wave")) {
                tooltip.wave();
            }
            if (data.contains("obfuscate")) {
                tooltip.obfuscate();
            }
            if (data.contains("align")) {
                tooltip.align(TextAnchor.fromInt(data.getInt("align")));
            }
            if (data.contains("anchor")) {
                tooltip.anchor(TextAnchor.fromInt(data.getInt("anchor")));
            }
            if (data.contains("color")) {
                tooltip.color((TextColor)TextColor.parseColor((String)data.getString("color")).getOrThrow());
            }
            if (data.contains("size")) {
                tooltip.size(data.getFloat("size"));
            }
            if (data.contains("y")) {
                tooltip.y(data.getFloat("y"));
            }
            if (data.contains("x")) {
                tooltip.x(data.getFloat("x"));
            }
            if (data.contains("font")) {
                tooltip.font(data.getString("font"));
            }
            if (data.contains("slideup")) {
                tooltip.slideUp();
            } else if (data.contains("slidedown")) {
                tooltip.slideDown();
            } else if (data.contains("slideleft")) {
                tooltip.slideLeft();
            } else if (data.contains("slideright")) {
                tooltip.slideRight();
            } else {
                tooltip.slideUp();
            }
            if (data.contains("slideoutup")) {
                tooltip.slideOutUp();
            } else if (data.contains("slideoutdown")) {
                tooltip.slideOutDown();
            } else if (data.contains("slideoutleft")) {
                tooltip.slideOutLeft();
            } else if (data.contains("slideoutright")) {
                tooltip.slideOutRight();
            }
            tooltip.sendServer(players);
            return 1;
        }))))))));
    }
}

