/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.util;

import com.google.common.hash.Hashing;
import java.util.function.UnaryOperator;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ImmersiveColor {
    public static final ImmersiveColor TRANSPARENT_BLACK = new ImmersiveColor(0, 0, 0, 0).setImmutable();
    public static final ImmersiveColor BLACK = new ImmersiveColor(0, 0, 0).setImmutable();
    public static final ImmersiveColor WHITE = new ImmersiveColor(255, 255, 255).setImmutable();
    public static final ImmersiveColor RED = new ImmersiveColor(255, 0, 0).setImmutable();
    public static final ImmersiveColor GREEN = new ImmersiveColor(0, 255, 0).setImmutable();
    public static final ImmersiveColor SPRING_GREEN = new ImmersiveColor(0, 255, 187).setImmutable();
    protected boolean mutable = true;
    protected int value;

    public ImmersiveColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ImmersiveColor(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public ImmersiveColor(float r, float g, float b, float a) {
        this((int)(0.5 + (double)(255.0f * Mth.clamp((float)r, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.clamp((float)g, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.clamp((float)b, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.clamp((float)a, (float)0.0f, (float)1.0f))));
    }

    public ImmersiveColor(int rgba) {
        this.value = rgba;
    }

    public ImmersiveColor(int rgb, boolean hasAlpha) {
        this.value = hasAlpha ? rgb : rgb | 0xFF000000;
    }

    public ImmersiveColor copy() {
        return this.copy(true);
    }

    public ImmersiveColor copy(boolean mutable) {
        if (mutable) {
            return new ImmersiveColor(this.value);
        }
        return new ImmersiveColor(this.value).setImmutable();
    }

    public ImmersiveColor setImmutable() {
        this.mutable = false;
        return this;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public float getRedAsFloat() {
        return (float)this.getRed() / 255.0f;
    }

    public float getGreenAsFloat() {
        return (float)this.getGreen() / 255.0f;
    }

    public float getBlueAsFloat() {
        return (float)this.getBlue() / 255.0f;
    }

    public float getAlphaAsFloat() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRGB() {
        return this.value;
    }

    public Vec3 asVector() {
        return new Vec3((double)this.getRedAsFloat(), (double)this.getGreenAsFloat(), (double)this.getBlueAsFloat());
    }

    public Vector3f asVectorF() {
        return new Vector3f(this.getRedAsFloat(), this.getGreenAsFloat(), this.getBlueAsFloat());
    }

    public ImmersiveColor setRed(int r) {
        return this.ensureMutable().setRedUnchecked(r);
    }

    public ImmersiveColor setGreen(int g) {
        return this.ensureMutable().setGreenUnchecked(g);
    }

    public ImmersiveColor setBlue(int b) {
        return this.ensureMutable().setBlueUnchecked(b);
    }

    public ImmersiveColor setAlpha(int a) {
        return this.ensureMutable().setAlphaUnchecked(a);
    }

    public ImmersiveColor setRed(float r) {
        return this.ensureMutable().setRedUnchecked((int)(255.0f * Mth.clamp((float)r, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor setGreen(float g) {
        return this.ensureMutable().setGreenUnchecked((int)(255.0f * Mth.clamp((float)g, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor setBlue(float b) {
        return this.ensureMutable().setBlueUnchecked((int)(255.0f * Mth.clamp((float)b, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor setAlpha(float a) {
        return this.ensureMutable().setAlphaUnchecked((int)(255.0f * Mth.clamp((float)a, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor scaleAlpha(float factor) {
        return this.ensureMutable().setAlphaUnchecked((int)((float)this.getAlpha() * Mth.clamp((float)factor, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor mixWith(ImmersiveColor other, float weight) {
        return this.ensureMutable().setRedUnchecked((int)((float)this.getRed() + (float)(other.getRed() - this.getRed()) * weight)).setGreenUnchecked((int)((float)this.getGreen() + (float)(other.getGreen() - this.getGreen()) * weight)).setBlueUnchecked((int)((float)this.getBlue() + (float)(other.getBlue() - this.getBlue()) * weight)).setAlphaUnchecked((int)((float)this.getAlpha() + (float)(other.getAlpha() - this.getAlpha()) * weight));
    }

    public ImmersiveColor darker() {
        int a = this.getAlpha();
        return this.ensureMutable().mixWith(BLACK, 0.25f).setAlphaUnchecked(a);
    }

    public ImmersiveColor brighter() {
        int a = this.getAlpha();
        return this.ensureMutable().mixWith(WHITE, 0.25f).setAlphaUnchecked(a);
    }

    public ImmersiveColor setValue(int value) {
        return this.ensureMutable().setValueUnchecked(value);
    }

    public ImmersiveColor modifyValue(UnaryOperator<Integer> function) {
        int newValue = (Integer)function.apply(this.value);
        if (newValue == this.value) {
            return this;
        }
        return this.ensureMutable().setValueUnchecked(newValue);
    }

    protected ImmersiveColor ensureMutable() {
        if (this.mutable) {
            return this;
        }
        return new ImmersiveColor(this.value);
    }

    protected ImmersiveColor setRedUnchecked(int r) {
        this.value = this.value & 0xFF00FFFF | (r & 0xFF) << 16;
        return this;
    }

    protected ImmersiveColor setGreenUnchecked(int g) {
        this.value = this.value & 0xFFFF00FF | (g & 0xFF) << 8;
        return this;
    }

    protected ImmersiveColor setBlueUnchecked(int b) {
        this.value = this.value & 0xFFFFFF00 | (b & 0xFF) << 0;
        return this;
    }

    protected ImmersiveColor setAlphaUnchecked(int a) {
        this.value = this.value & 0xFFFFFF | (a & 0xFF) << 24;
        return this;
    }

    protected ImmersiveColor setValueUnchecked(int value) {
        this.value = value;
        return this;
    }

    public static ImmersiveColor mixColors(ImmersiveColor c1, ImmersiveColor c2, float w) {
        return new ImmersiveColor((int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * w), (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * w), (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * w), (int)((float)c1.getAlpha() + (float)(c2.getAlpha() - c1.getAlpha()) * w));
    }

    public static int mixColors(int color1, int color2, float w) {
        int a1 = color1 >> 24;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return ((int)((float)a1 + (float)(a2 - a1) * w) << 24) + ((int)((float)r1 + (float)(r2 - r1) * w) << 16) + ((int)((float)g1 + (float)(g2 - g1) * w) << 8) + ((int)((float)b1 + (float)(b2 - b1) * w) << 0);
    }

    public static ImmersiveColor rainbowColor(int timeStep) {
        int localTimeStep = Math.abs(timeStep) % 1536;
        int timeStepInPhase = localTimeStep % 256;
        int phaseBlue = localTimeStep / 256;
        int red = ImmersiveColor.colorInPhase(phaseBlue + 4, timeStepInPhase);
        int green = ImmersiveColor.colorInPhase(phaseBlue + 2, timeStepInPhase);
        int blue = ImmersiveColor.colorInPhase(phaseBlue, timeStepInPhase);
        return new ImmersiveColor(red, green, blue);
    }

    private static int colorInPhase(int phase, int progress) {
        if ((phase %= 6) <= 1) {
            return 0;
        }
        if (phase == 2) {
            return progress;
        }
        if (phase <= 4) {
            return 255;
        }
        return 255 - progress;
    }

    public static ImmersiveColor generateFromLong(long l) {
        return ImmersiveColor.rainbowColor(Hashing.crc32().hashLong(l).asInt()).mixWith(WHITE, 0.5f);
    }
}

