/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import org.joml.Vector2i;
import org.joml.Vector3i;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.util.AnimationUtil;
import toni.immersivemessages.util.ImmersiveColor;

public class RenderUtil {
    private static double totalTicks = 0.0;

    public static void drawBackground(ImmersiveMessage tooltip, GuiGraphics graphics, Vector3i size, Vector2i bgOffset, float deltaTicks) {
        ImmersiveColor colorBorderBot;
        ImmersiveColor colorBorderTop;
        int width = size.x;
        int height = size.y;
        int titleLinesCount = size.z;
        int xMaxL = -3;
        int xMinL = -4;
        int xMinR = width + 3;
        int xMaxR = width + 4;
        int yMaxT = -4;
        int yMinT = -5;
        int yMaxB = height + 4;
        int yMinB = height + 3;
        float fade = (float)FastColor.ARGB32.alpha((int)tooltip.animation.getColor()) / 255.0f;
        ImmersiveColor colorBackground = tooltip.colorBackground.copy().scaleAlpha(0.75f * fade);
        if (tooltip.rainbow >= 0.0f) {
            colorBorderTop = ImmersiveColor.rainbowColor((int)(totalTicks += (double)(deltaTicks * tooltip.rainbow))).scaleAlpha(0.75f * fade);
            colorBorderBot = ImmersiveColor.rainbowColor((int)totalTicks).scaleAlpha(0.75f * fade);
        } else {
            colorBorderTop = tooltip.colorBorderTop.copy().scaleAlpha(0.75f * fade);
            colorBorderBot = tooltip.colorBorderBot.copy().scaleAlpha(0.75f * fade);
        }
        int backgroundColor = colorBackground.getRGB();
        int borderColorStart = colorBorderTop.getRGB();
        int borderColorEnd = colorBorderBot.getRGB();
        graphics.pose().pushPose();
        graphics.pose().translate((float)bgOffset.x, (float)bgOffset.y, -5.0f);
        AnimationUtil.applyPose(tooltip.animation, graphics, bgOffset, tooltip.anchor, tooltip.align, size.x, size.y);
        graphics.fillGradient(xMaxL, yMinT, xMinR, yMaxT, backgroundColor, backgroundColor);
        graphics.fillGradient(xMaxL, yMinB, xMinR, yMaxB, backgroundColor, backgroundColor);
        graphics.fillGradient(xMaxL, yMaxT, xMinR, yMinB, backgroundColor, backgroundColor);
        graphics.fillGradient(xMinL, yMaxT, xMaxL, yMinB, backgroundColor, backgroundColor);
        graphics.fillGradient(xMinR, yMaxT, xMaxR, yMinB, backgroundColor, backgroundColor);
        graphics.fillGradient(xMaxL, yMaxT + 1, xMaxL + 1, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.fillGradient(xMinR - 1, yMaxT + 1, xMinR, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.fillGradient(xMaxL, yMaxT, xMinR, yMaxT + 1, borderColorStart, borderColorStart);
        graphics.fillGradient(xMaxL, yMinB - 1, xMinR, yMinB, borderColorEnd, borderColorEnd);
        graphics.pose().popPose();
    }

    public static Vector3i wrapText(List<FormattedText> textLines, int maxTextWidth, Function<FormattedText, Integer> widthLookup) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        Font font = mc.font;
        int tooltipTextWidth = 0;
        for (FormattedText textLine : textLines) {
            int textLineWidth = widthLookup.apply(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        if (maxTextWidth >= 0) {
            if (tooltipTextWidth > screenWidth / 2) {
                tooltipTextWidth = screenWidth / 2;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (int i = 0; i < textLines.size(); ++i) {
                FormattedText textLine = textLines.get(i);
                List wrappedLine = font.getSplitter().splitLines(textLine, tooltipTextWidth, Style.EMPTY);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = widthLookup.apply(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines.clear();
            textLines.addAll(wrappedTextLines);
        }
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        return new Vector3i(tooltipTextWidth, tooltipHeight, titleLinesCount);
    }
}

