/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.config;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.InlineClientConfig;
import com.samsthenerd.inline.impl.MatchCacher;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.shedaniel.cloth.clothconfig.shadowed.com.moandjiezana.toml.Toml;
import me.shedaniel.cloth.clothconfig.shadowed.com.moandjiezana.toml.TomlWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class InlineClientConfigImpl
implements InlineClientConfig {
    private static final String clientConfigSubPath = "config" + File.separator + "inline" + File.separator + "client-config.toml";
    public static final TomlWriter TOML_WRITER = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(3).build();
    private File configFile;
    private static InlineClientConfigImpl INSTANCE;
    private Set<ResourceLocation> disabledMatchers = new HashSet<ResourceLocation>();
    private boolean renderModIcon = true;
    private boolean doCreateMixin = true;
    private double chatScaleCap = 1.5;
    private boolean dirty = false;

    public static InlineClientConfigImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InlineClientConfigImpl(new File(Minecraft.getInstance().gameDirectory, clientConfigSubPath));
        }
        return INSTANCE;
    }

    private InlineClientConfigImpl(File configFile) {
        this.configFile = configFile;
        if (!this.configFile.exists()) {
            File dir = this.configFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.writeToFile();
        } else {
            this.reloadFromFile();
        }
    }

    protected void reloadFromFile() {
        try {
            Toml config = new Toml().read(this.configFile);
            List dMatchers = config.getList("disabledMatchers", List.of());
            this.disabledMatchers.clear();
            for (String mId : dMatchers) {
                this.disabledMatchers.add(ResourceLocation.parse((String)mId));
            }
            this.renderModIcon = config.getBoolean("modIconInTooltip", Boolean.valueOf(true));
            this.dirty = false;
        }
        catch (Exception e) {
            Inline.LOGGER.error("Failed to read inline client config file: " + this.configFile.getAbsolutePath(), (Throwable)e);
        }
    }

    protected void writeToFile() {
        HashMap<String, Serializable> configMap = new HashMap<String, Serializable>();
        ArrayList<String> disabledMatcherIds = new ArrayList<String>();
        for (ResourceLocation matcherId : this.disabledMatchers) {
            disabledMatcherIds.add(matcherId.toString());
        }
        configMap.put("disabledMatchers", disabledMatcherIds);
        configMap.put("modIconInTooltip", Boolean.valueOf(this.renderModIcon));
        this.dirty = false;
        try {
            TOML_WRITER.write(configMap, this.configFile);
        }
        catch (Exception e) {
            Inline.LOGGER.error("Failed to write inline client config file: " + this.configFile.getAbsolutePath(), (Throwable)e);
        }
    }

    protected void save() {
        if (this.dirty) {
            this.writeToFile();
        }
    }

    protected void enableMatcher(ResourceLocation matcherId) {
        this.disabledMatchers.remove(matcherId);
        this.dirty = true;
        MatchCacher.clear();
    }

    protected void disableMatcher(ResourceLocation matcherId) {
        this.disabledMatchers.add(matcherId);
        this.dirty = true;
        MatchCacher.clear();
    }

    protected void someableMatcher(ResourceLocation matcherId, boolean enableOrDisable) {
        if (enableOrDisable) {
            this.enableMatcher(matcherId);
        } else {
            this.disableMatcher(matcherId);
        }
    }

    @Override
    public boolean isMatcherEnabled(ResourceLocation matcherId) {
        return !this.disabledMatchers.contains(matcherId);
    }

    @Override
    public boolean shouldRenderModIcons() {
        return this.renderModIcon;
    }

    public void setShouldRenderModIcons(boolean should) {
        this.renderModIcon = should;
        this.dirty = true;
    }

    @Override
    public boolean shouldDoCreateMixins() {
        return this.doCreateMixin;
    }

    public void setShouldDoCreateMixins(boolean should) {
        this.doCreateMixin = should;
        this.dirty = true;
    }

    @Override
    public double maxChatSizeModifier() {
        return this.chatScaleCap;
    }

    public void setChatScaleCap(double newCap) {
        this.chatScaleCap = newCap;
        this.dirty = true;
    }
}

