/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.mixin.feature;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class}, priority=10000)
public class MixinAddModIconToTooltip {
    @ModifyReturnValue(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private List<Component> findAndAddModIcon(List<Component> originalTT) {
        if (!InlineClientAPI.INSTANCE.getConfig().shouldRenderModIcons()) {
            return originalTT;
        }
        ItemStack thisStack = (ItemStack)this;
        String modNamespace = BuiltInRegistries.ITEM.getKey((Object)thisStack.getItem()).getNamespace();
        if (modNamespace.equals("") || modNamespace.equals("minecraft")) {
            return originalTT;
        }
        Optional<IModMeta> maybeMod = IModMeta.getMod(modNamespace);
        if (maybeMod.isEmpty()) {
            return originalTT;
        }
        IModMeta mod = maybeMod.get();
        String modName = mod.getName();
        ArrayList<Component> newTT = new ArrayList<Component>();
        for (Component comp : originalTT) {
            if (comp.getString().equals(modName)) {
                newTT.add((Component)comp.copy().append((Component)Component.literal((String)" ")).append(ModIconData.makeModIcon(mod)));
                continue;
            }
            newTT.add(comp);
        }
        return newTT;
    }
}

