/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import com.relimer.ironsrestrictions.registries.DataAttachmentRegistry;
import com.relimer.ironsrestrictions.util.ConfigurableRarity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.command.EnumArgument;

public class LearnRarityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rarity").requires(p -> p.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"rarity", (ArgumentType)EnumArgument.enumArgument(ConfigurableRarity.class)).executes(context -> {
            ConfigurableRarity rarity = (ConfigurableRarity)((Object)((Object)context.getArgument("rarity", ConfigurableRarity.class)));
            return LearnRarityCommand.set((CommandSourceStack)context.getSource(), rarity);
        }))));
    }

    private static int set(CommandSourceStack source, ConfigurableRarity rarity) {
        ServerPlayer player = source.getPlayer();
        SyncedRarityData rarityData = (SyncedRarityData)player.getData(DataAttachmentRegistry.RARITY_DATA);
        rarityData.setRarity(rarity.getSpellRarity());
        source.sendSuccess(() -> source.getDisplayName().copy().append(" set to rarity: " + rarity.name()), false);
        return 1;
    }
}

