/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.datagen;

import com.relimer.ironsrestrictions.datagen.LootModifierProvider;
import com.relimer.ironsrestrictions.datagen.RModelProvider;
import com.relimer.ironsrestrictions.datagen.RRecipeProvider;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="irons_restrictions")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new RModelProvider(packOutput, "irons_restrictions", existingFileHelper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for ISS Restrictions"), DetectedVersion.BUILT_IN.getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty())));
    }
}

