/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.datagen;

import com.relimer.ironsrestrictions.registries.ComponentRegistry;
import com.relimer.ironsrestrictions.registries.ItemRegistry;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import com.relimer.ironsrestrictions.util.SchoolUtils;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.BrewAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.FillAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.registries.FluidRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RRecipeProvider
extends RecipeProvider {
    public RRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        SchoolUtils.getLoopSchools().forEach(holder -> {
            ItemStack itemStack = new ItemStack(ItemRegistry.MANUSCRIPT);
            itemStack.set(ComponentRegistry.SCHOOL_COMPONENT, (Object)new SchoolContainer((SchoolType)holder.value()));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)itemStack).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)ItemRegistry.FRAGMENT.get()).define(Character.valueOf('B'), ((SchoolType)holder.value()).getFocus()).unlockedBy("has_fragment", RRecipeProvider.has((ItemLike)((ItemLike)ItemRegistry.FRAGMENT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)(((SchoolType)holder.value()).getId().getPath() + "_manuscript")));
        });
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.FRAGMENT.get()), (int)2).requires((ItemLike)io.redspace.ironsspellbooks.registries.ItemRegistry.SCROLL.get()).unlockedBy("has_scroll", RRecipeProvider.has((ItemLike)((ItemLike)io.redspace.ironsspellbooks.registries.ItemRegistry.SCROLL.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"fragment"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.UNFINISHED_MANUSCRIPT.get())).requires((ItemLike)ItemRegistry.FRAGMENT.get()).requires((ItemLike)io.redspace.ironsspellbooks.registries.ItemRegistry.MAGIC_CLOTH.get(), 4).unlockedBy("has_fragment", RRecipeProvider.has((ItemLike)((ItemLike)ItemRegistry.FRAGMENT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"unfinished_manuscript"));
        BrewAlchemistCauldronRecipe.builder().withInput((Holder)FluidRegistry.COMMON_INK, 1000).withReagent((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withByproduct(ItemRegistry.COMMON_UPGRADE).saveSoak(recipeOutput);
        BrewAlchemistCauldronRecipe.builder().withInput((Holder)FluidRegistry.UNCOMMON_INK, 1000).withReagent((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withByproduct(ItemRegistry.UNCOMMON_UPGRADE).saveSoak(recipeOutput);
        BrewAlchemistCauldronRecipe.builder().withInput((Holder)FluidRegistry.RARE_INK, 1000).withReagent((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withByproduct(ItemRegistry.RARE_UPGRADE).saveSoak(recipeOutput);
        BrewAlchemistCauldronRecipe.builder().withInput((Holder)FluidRegistry.EPIC_INK, 1000).withReagent((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withByproduct(ItemRegistry.EPIC_UPGRADE).saveSoak(recipeOutput);
        BrewAlchemistCauldronRecipe.builder().withInput((Holder)FluidRegistry.LEGENDARY_INK, 1000).withReagent((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withByproduct(ItemRegistry.LEGENDARY_UPGRADE).saveSoak(recipeOutput);
        new FillAlchemistCauldronRecipe.Builder().withInput((Item)ItemRegistry.COMMON_UPGRADE.get()).withReturnItem((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withFluid(new FluidStack((Holder)FluidRegistry.COMMON_INK, 1000)).withSound(SoundEvents.BOTTLE_EMPTY).mustFitAll(true).save(recipeOutput);
        new FillAlchemistCauldronRecipe.Builder().withInput((Item)ItemRegistry.UNCOMMON_UPGRADE.get()).withReturnItem((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withFluid(new FluidStack((Holder)FluidRegistry.UNCOMMON_INK, 1000)).withSound(SoundEvents.BOTTLE_EMPTY).mustFitAll(true).save(recipeOutput);
        new FillAlchemistCauldronRecipe.Builder().withInput((Item)ItemRegistry.RARE_UPGRADE.get()).withReturnItem((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withFluid(new FluidStack((Holder)FluidRegistry.RARE_INK, 1000)).withSound(SoundEvents.BOTTLE_EMPTY).mustFitAll(true).save(recipeOutput);
        new FillAlchemistCauldronRecipe.Builder().withInput((Item)ItemRegistry.EPIC_UPGRADE.get()).withReturnItem((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withFluid(new FluidStack((Holder)FluidRegistry.EPIC_INK, 1000)).withSound(SoundEvents.BOTTLE_EMPTY).mustFitAll(true).save(recipeOutput);
        new FillAlchemistCauldronRecipe.Builder().withInput((Item)ItemRegistry.LEGENDARY_UPGRADE.get()).withReturnItem((Item)io.redspace.ironsspellbooks.registries.ItemRegistry.UPGRADE_ORB.get()).withFluid(new FluidStack((Holder)FluidRegistry.LEGENDARY_INK, 1000)).withSound(SoundEvents.BOTTLE_EMPTY).mustFitAll(true).save(recipeOutput);
    }
}

