/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.item;

import com.relimer.ironsrestrictions.IronsRestrictions;
import com.relimer.ironsrestrictions.network.OpenSchoolScreenPacket;
import com.relimer.ironsrestrictions.registries.ComponentRegistry;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class Manuscript
extends Item {
    public Manuscript() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    private SchoolContainer getOrCreate(ItemStack itemStack) {
        return (SchoolContainer)itemStack.getOrDefault((DataComponentType)ComponentRegistry.SCHOOL_COMPONENT.get(), (Object)new SchoolContainer((SchoolType)SchoolRegistry.FIRE.get()));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = player.getItemInHand(pUsedHand);
        ItemStack offHand = player.getOffhandItem();
        ItemStack mainHand = player.getMainHandItem();
        IronsRestrictions.LOGGER.info("Player: " + String.valueOf(player));
        ItemStack scrollHand = null;
        if (offHand.is((Holder)ItemRegistry.SCROLL)) {
            scrollHand = offHand;
        }
        if (mainHand.is((Holder)ItemRegistry.SCROLL)) {
            scrollHand = mainHand;
        }
        if (player instanceof ServerPlayer) {
            SpellData spellSlot;
            AbstractSpell spell;
            SchoolType school;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (scrollHand != null && (school = (spell = (spellSlot = ISpellContainer.getOrCreate((ItemStack)scrollHand).getSpellAtIndex(0)).getSpell()).getSchoolType()) == ((SchoolContainer)itemStack.get(ComponentRegistry.SCHOOL_COMPONENT)).getSchoolType() && !spell.isLearned(player)) {
                SyncedSpellData data = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData();
                data.learnSpell(spell);
                IronsRestrictions.LOGGER.info(player.getName().getString() + " learnt Spell: " + String.valueOf(spell));
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.manuscript.learn_scroll").append(spell.getDisplayName(player).getString()).withStyle(ChatFormatting.GOLD), true);
                player.playNotifySound((SoundEvent)SoundRegistry.LEARN_ELDRITCH_SPELL.get(), SoundSource.MASTER, 1.0f, (float)Utils.random.nextIntBetweenInclusive(9, 11) * 0.1f);
                if (!serverPlayer.gameMode.isCreative()) {
                    itemStack.shrink(1);
                }
                player.getCooldowns().addCooldown(scrollHand.getItem(), 20);
                return InteractionResultHolder.success((Object)itemStack);
            }
            IronsRestrictions.LOGGER.info("Server Player: " + String.valueOf(serverPlayer));
            SchoolContainer schoolComponent = (SchoolContainer)itemStack.getOrDefault((DataComponentType)ComponentRegistry.SCHOOL_COMPONENT.get(), (Object)new SchoolContainer((SchoolType)SchoolRegistry.FIRE.get()));
            IronsRestrictions.LOGGER.info("Component: " + String.valueOf(schoolComponent));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenSchoolScreenPacket(pUsedHand, schoolComponent.getSchoolType()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            IronsRestrictions.LOGGER.info("Success");
            return InteractionResultHolder.success((Object)itemStack);
        }
        IronsRestrictions.LOGGER.info("Fail");
        return InteractionResultHolder.fail((Object)itemStack);
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        SchoolContainer data = this.getOrCreate(itemStack);
        return Component.translatable((String)data.getManuscriptId());
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> lines, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, lines, pIsAdvanced);
        MinecraftInstanceHelper.ifPlayerPresent(player -> {
            SchoolContainer data = this.getOrCreate(pStack);
            lines.add((Component)Component.translatable((String)data.getManuscriptDescription()).withStyle(ChatFormatting.GRAY));
        });
    }
}

