/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.item;

import com.relimer.ironsrestrictions.anim.Animations;
import com.relimer.ironsrestrictions.network.PlayAnimationPacket;
import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import com.relimer.ironsrestrictions.registries.DataAttachmentRegistry;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class RarityUpgrade
extends Item {
    SpellRarity rarity;
    SpellRarity prevRarity;
    int requiredAdvancements;

    public RarityUpgrade(SpellRarity rarity, SpellRarity previousRarity, int reqAdv) {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1));
        this.rarity = rarity;
        this.prevRarity = previousRarity;
        this.requiredAdvancements = reqAdv;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = player.getItemInHand(pUsedHand);
        SyncedRarityData rarityData = (SyncedRarityData)player.getData(DataAttachmentRegistry.RARITY_DATA);
        SpellRarity currentRarity = rarityData.getRarity();
        if (!level.isClientSide && player instanceof ServerPlayer) {
            int prevValue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            int value = currentRarity == null ? -1 : currentRarity.getValue();
            if (value < (prevValue = this.prevRarity == null ? -1 : this.prevRarity.getValue())) {
                player.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.upgrade.fail_below").withStyle(ChatFormatting.DARK_RED), true);
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (value > prevValue) {
                player.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.upgrade.fail_above").withStyle(ChatFormatting.DARK_RED), true);
                return InteractionResultHolder.fail((Object)itemStack);
            }
            player.playNotifySound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), SoundSource.MASTER, 1.0f, (float)Utils.random.nextIntBetweenInclusive(9, 11) * 0.1f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, player.getX(), player.getY(), player.getZ(), 50, 0.5, 1.0, 0.5, 0.5);
            rarityData.setRarity(this.rarity);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayAnimationPacket(Animations.UPGRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!serverPlayer.gameMode.isCreative()) {
                itemStack.shrink(1);
            }
            player.getCooldowns().addCooldown((Item)this, 20);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> lines, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, lines, pIsAdvanced);
        MinecraftInstanceHelper.ifPlayerPresent(player -> lines.add((Component)Component.translatable((String)"item.irons_restrictions.upgrade_desc").withStyle(ChatFormatting.GRAY)));
    }
}

