/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.item;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.IronsRestrictions;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class UnfinishedManuscript
extends Item {
    public UnfinishedManuscript() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = player.getItemInHand(pUsedHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                ItemStack stack = player.getItemInHand(pUsedHand);
                return InteractionResultHolder.fail((Object)stack);
            }
            double failureChance = Config.FailChance.getAsDouble();
            List spellIds = (List)Config.ExcludeRandomLearntSpells.get();
            ArrayList<AbstractSpell> learnableSpells = new ArrayList<AbstractSpell>(SpellRegistry.getEnabledSpells().stream().filter(spell -> !spell.isLearned(player)).toList());
            for (String spellId : spellIds) {
                String namespace = spellId.split(":")[0];
                String path = spellId.split(":")[1];
                try {
                    ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                    AbstractSpell spell2 = SpellRegistry.getSpell((ResourceLocation)id);
                    if (spell2 == null) continue;
                    learnableSpells.remove(spell2);
                }
                catch (Exception exception) {}
            }
            if (learnableSpells.isEmpty()) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.unfinished_manuscript.full"), true);
                player.playNotifySound(SoundEvents.FLINTANDSTEEL_USE, SoundSource.MASTER, 1.0f, (float)Utils.random.nextIntBetweenInclusive(9, 11) * 0.1f);
                IronsRestrictions.LOGGER.info(player.getName().getString() + " Already Knows All Spells");
                return InteractionResultHolder.fail((Object)itemStack);
            }
            AbstractSpell chosenSpell = learnableSpells.get(player.getRandom().nextInt(learnableSpells.size()));
            SyncedSpellData data = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData();
            if (player.getRandom().nextDouble() < failureChance) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.unfinished_manuscript.fail").withStyle(ChatFormatting.DARK_RED), true);
                player.playNotifySound(SoundEvents.FIRE_EXTINGUISH, SoundSource.MASTER, 1.0f, (float)Utils.random.nextIntBetweenInclusive(9, 11) * 0.1f);
                IronsRestrictions.LOGGER.info(player.getName().getString() + "'s Manuscript Crumbled");
            } else if (chosenSpell != SpellRegistry.none() && !data.isSpellLearned(chosenSpell) && itemStack.getCount() > 0) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.irons_restrictions.unfinished_manuscript.success").append(chosenSpell.getDisplayName(player).getString()).withStyle(ChatFormatting.GOLD), true);
                player.playNotifySound((SoundEvent)SoundRegistry.LEARN_ELDRITCH_SPELL.get(), SoundSource.MASTER, 1.0f, (float)Utils.random.nextIntBetweenInclusive(9, 11) * 0.1f);
                data.learnSpell(chosenSpell);
                IronsRestrictions.LOGGER.info(player.getName().getString() + " learnt Spell: " + String.valueOf(chosenSpell));
            } else {
                IronsRestrictions.LOGGER.error(player.getName().getString() + " failed to learn spell: " + String.valueOf(chosenSpell) + "\nI wonder what went wrong?");
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (!serverPlayer.gameMode.isCreative()) {
                itemStack.shrink(1);
            }
            player.getCooldowns().addCooldown((Item)this, 20);
            return InteractionResultHolder.success((Object)itemStack);
        }
        IronsRestrictions.LOGGER.error("Failed to learn spell, is this client-side?");
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> lines, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, lines, pIsAdvanced);
        MinecraftInstanceHelper.ifPlayerPresent(player -> lines.add((Component)Component.translatable((String)"item.irons_restrictions.unfinished_manuscript_desc").withStyle(ChatFormatting.GRAY)));
    }
}

