/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.relimer.ironsrestrictions.registries.LootConditionRegistry;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ChestLootCondition
implements LootItemCondition {
    public static final MapCodec<ChestLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("dummy").forGetter(c -> true)).apply((Applicative)instance, dummy -> new ChestLootCondition()));

    public LootItemConditionType getType() {
        return LootConditionRegistry.IS_CHEST_LOOT.get();
    }

    public boolean test(LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        return lootTableId != null && lootTableId.getPath().startsWith("chests/");
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }
}

