/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.network;

import com.relimer.ironsrestrictions.player.RClientSpellCastHelper;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenSchoolScreenPacket
implements CustomPacketPayload {
    private final InteractionHand hand;
    private static SchoolType schoolType;
    public static final CustomPacketPayload.Type<OpenSchoolScreenPacket> TYPE;
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenSchoolScreenPacket> STREAM_CODEC;

    public OpenSchoolScreenPacket(FriendlyByteBuf buf) {
        this.hand = (InteractionHand)buf.readEnum(InteractionHand.class);
        ResourceLocation id = buf.readResourceLocation();
        schoolType = (SchoolType)SchoolRegistry.REGISTRY.get(id);
    }

    public OpenSchoolScreenPacket(InteractionHand pHand, SchoolType schoolType) {
        this.hand = pHand;
        OpenSchoolScreenPacket.schoolType = schoolType;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.hand);
        buf.writeResourceLocation(schoolType.getId());
    }

    public static void handle(OpenSchoolScreenPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> RClientSpellCastHelper.openSchoolResearchScreen(packet.hand, schoolType));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"open_school_screen"));
        STREAM_CODEC = CustomPacketPayload.codec(OpenSchoolScreenPacket::write, OpenSchoolScreenPacket::new);
    }
}

