/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.network.spells;

import com.relimer.ironsrestrictions.network.spells.ClientRarityData;
import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPlayerRarityDataPacket
implements CustomPacketPayload {
    SyncedRarityData syncedSpellData;
    public static final CustomPacketPayload.Type<SyncPlayerRarityDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"sync_player_rarity_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPlayerRarityDataPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncPlayerRarityDataPacket::write, SyncPlayerRarityDataPacket::new);

    public SyncPlayerRarityDataPacket(SyncedRarityData playerSyncedData) {
        this.syncedSpellData = playerSyncedData;
    }

    public SyncPlayerRarityDataPacket(FriendlyByteBuf buf) {
        this.syncedSpellData = SyncedRarityData.read(buf);
    }

    public void write(FriendlyByteBuf buf) {
        SyncedRarityData.write(buf, this.syncedSpellData);
    }

    public static void handle(SyncPlayerRarityDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientRarityData.handlePlayerSyncedData(packet.syncedSpellData));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

