/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.player;

import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import com.relimer.ironsrestrictions.registries.DataAttachmentRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="irons_restrictions")
public class PlayerRarityProvider
implements IAttachmentSerializer<CompoundTag, SyncedRarityData> {
    @NotNull
    public SyncedRarityData read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
        SyncedRarityData data = new SyncedRarityData((LivingEntity)((ServerPlayer)holder));
        data.loadNBTData(tag, provider);
        return data;
    }

    @Nullable
    public CompoundTag write(SyncedRarityData attachment, HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        attachment.saveNBTData(compound, provider);
        return compound;
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            SyncedRarityData oldRarity = (SyncedRarityData)event.getOriginal().getData(DataAttachmentRegistry.RARITY_DATA);
            SyncedRarityData newRarity = (SyncedRarityData)newPlayer.getData(DataAttachmentRegistry.RARITY_DATA);
            newRarity.copyFrom(oldRarity);
        }
    }
}

