/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.registries;

import com.relimer.ironsrestrictions.registries.ComponentRegistry;
import com.relimer.ironsrestrictions.registries.ItemRegistry;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import com.relimer.ironsrestrictions.util.SchoolUtils;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="irons_restrictions")
public class CreativeTabRegistry {
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"irons_restrictions");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> RESTRICTIONS_TAB = TABS.register("restrictions_items_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.irons_restrictions.restrictions_items_tab")).icon(() -> new ItemStack((ItemLike)ItemRegistry.MANUSCRIPT.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).build());

    public static void register(IEventBus eventBus) {
        TABS.register(eventBus);
    }

    @SubscribeEvent
    public static void fillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == RESTRICTIONS_TAB.get()) {
            SchoolUtils.getLoopSchools().forEach(holder -> {
                SchoolType schoolType = (SchoolType)holder.value();
                ItemStack manuscript = new ItemStack(ItemRegistry.MANUSCRIPT);
                manuscript.set((DataComponentType)ComponentRegistry.SCHOOL_COMPONENT.get(), (Object)new SchoolContainer(schoolType));
                event.accept(manuscript);
            });
            event.accept((ItemLike)ItemRegistry.FRAGMENT.get());
            event.accept((ItemLike)ItemRegistry.UNFINISHED_MANUSCRIPT.get());
            event.accept((ItemLike)ItemRegistry.COMMON_UPGRADE.get());
            event.accept((ItemLike)ItemRegistry.UNCOMMON_UPGRADE.get());
            event.accept((ItemLike)ItemRegistry.RARE_UPGRADE.get());
            event.accept((ItemLike)ItemRegistry.EPIC_UPGRADE.get());
            event.accept((ItemLike)ItemRegistry.LEGENDARY_UPGRADE.get());
        }
    }
}

