/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.render;

import com.relimer.ironsrestrictions.registries.ComponentRegistry;
import com.relimer.ironsrestrictions.render.NBTOverrideItemModel;
import com.relimer.ironsrestrictions.util.ISchoolContainer;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import com.relimer.ironsrestrictions.util.TextureUtils;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Optional;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ManuscriptModel
extends NBTOverrideItemModel {
    public ManuscriptModel(BakedModel original, ModelBakery loader) {
        super(original, loader);
    }

    @Override
    public Optional<ResourceLocation> getModelFromStack(ItemStack itemStack) {
        if (ISchoolContainer.isSchoolContainer(itemStack)) {
            SchoolType school = ((SchoolContainer)itemStack.get(ComponentRegistry.SCHOOL_COMPONENT)).getSchoolType();
            return Optional.of(ManuscriptModel.getManuscriptModelLocation(school));
        }
        return Optional.empty();
    }

    public static ResourceLocation getManuscriptModelLocation(SchoolType schoolType) {
        return TextureUtils.getModelOrDefault(ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)String.format("item/%s_manuscript", schoolType.getId().getPath())), ResourceLocation.fromNamespaceAndPath((String)"irons_restrictions", (String)"item/manuscript"));
    }
}

