/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.setup;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.IronsRestrictions;
import com.relimer.ironsrestrictions.anim.Animations;
import com.relimer.ironsrestrictions.registries.ComponentRegistry;
import com.relimer.ironsrestrictions.registries.ItemRegistry;
import com.relimer.ironsrestrictions.render.ManuscriptModel;
import com.relimer.ironsrestrictions.util.SchoolContainer;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="irons_restrictions")
public class ClientSetup {
    @SubscribeEvent
    public static void clintSetup(FMLClientSetupEvent event) {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(Animations.ANIMATION_RESOURCE, 42, ClientSetup::registerPlayerAnimation);
    }

    private static IAnimation registerPlayerAnimation(AbstractClientPlayer player) {
        return new ModifierLayer();
    }

    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            SchoolContainer schoolContainer;
            if ((((Boolean)Config.TintBasePage.get()).booleanValue() && tintIndex == 1 || ((Boolean)Config.TintOverlayPage.get()).booleanValue() && tintIndex == 2) && (schoolContainer = (SchoolContainer)stack.get(ComponentRegistry.SCHOOL_COMPONENT)) != null) {
                return schoolContainer.getSchoolColour();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemRegistry.MANUSCRIPT.get()});
    }

    @SubscribeEvent
    public static void registerSpecialModels(ModelEvent.RegisterAdditional event) {
        for (SchoolType schoolType : SchoolRegistry.REGISTRY) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)ManuscriptModel.getManuscriptModelLocation(schoolType)));
        }
    }

    @SubscribeEvent
    public static void replaceItemModels(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation key = new ModelResourceLocation(IronsRestrictions.id("manuscript"), "inventory");
        event.getModels().computeIfPresent(key, (k, oldModel) -> new ManuscriptModel((BakedModel)oldModel, event.getModelBakery()){});
    }
}

