/*
 * Decompiled with CFR 0.152.
 */
package com.relimer.ironsrestrictions.util;

import com.mojang.serialization.Codec;
import com.relimer.ironsrestrictions.util.ISchoolContainer;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class SchoolContainer
implements ISchoolContainer {
    private final SchoolType schoolType;
    public static final Codec<SchoolType> SCHOOL_TYPE_CODEC = SchoolRegistry.REGISTRY.byNameCodec();
    public static final Codec<SchoolContainer> CODEC = SCHOOL_TYPE_CODEC.xmap(SchoolContainer::new, SchoolContainer::getSchoolType);
    public static final StreamCodec<RegistryFriendlyByteBuf, SchoolContainer> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);

    public SchoolContainer(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public String getManuscriptId() {
        return String.format("item.%s.%s_manuscript", "irons_restrictions", this.getSchoolId().getPath());
    }

    public String getManuscriptDescription() {
        return String.format("item.%s.%s_manuscript_desc", "irons_restrictions", this.getSchoolId().getPath());
    }

    public String getKnowledgeFragmentID() {
        return String.format("item.%s.%s_knowledge_fragment", "irons_restrictions", this.getSchoolId().getPath());
    }

    public SchoolType getSchoolType() {
        return this.schoolType;
    }

    public int getSchoolColour() {
        return 0xFF000000 | Objects.requireNonNull(this.schoolType.getDisplayName().getStyle().getColor()).getValue();
    }

    @Override
    public ResourceLocation getSchoolId() {
        return this.schoolType.getId();
    }

    @Override
    public void setSchoolId(ResourceLocation id) {
        throw new UnsupportedOperationException("Immutable container. Use a new instance instead.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchoolContainer that = (SchoolContainer)o;
        return this.schoolType.equals(that.schoolType);
    }

    public int hashCode() {
        return this.schoolType.hashCode();
    }
}

