/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.ironsrestrictionsmixin;

import com.relimer.ironsrestrictions.Config;
import com.relimer.ironsrestrictions.network.spells.SyncedRarityData;
import com.relimer.ironsrestrictions.registries.DataAttachmentRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={AbstractSpell.class})
public class AbstractSpellMixin {
    @Inject(method={"canBeCastedBy"}, at={@At(value="INVOKE", target="Lio/redspace/ironsspellbooks/api/spells/AbstractSpell;isLearned(Lnet/minecraft/world/entity/player/Player;)Z")}, cancellable=true)
    private void onCanBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player, CallbackInfoReturnable<CastResult> cir) {
        AbstractSpell spell = (AbstractSpell)this;
        if (spell.requiresLearning() && this.redirectIsLearned(spell, player) && !this.irons_Restrictions$hasUnlockedRarity(spell, spellLevel, player)) {
            cir.setReturnValue((Object)new CastResult(CastResult.Type.FAILURE, (Component)Component.translatable((String)"ui.irons_restrictions.cast_error_rarity").withStyle(ChatFormatting.RED)));
        }
    }

    @Redirect(method={"canBeCastedBy"}, at=@At(value="INVOKE", target="Lio/redspace/ironsspellbooks/api/spells/AbstractSpell;isLearned(Lnet/minecraft/world/entity/player/Player;)Z"))
    private boolean redirectIsLearned(AbstractSpell spell, Player player) {
        if (player == null) {
            return false;
        }
        if (spell.isLearned(player)) {
            return true;
        }
        return this.irons_Restrictions$imbuedChecks(spell, player);
    }

    @Unique
    private boolean irons_Restrictions$hasUnlockedRarity(AbstractSpell abstractSpell, int spellLevel, Player player) {
        SpellRarity rarity = abstractSpell.getRarity(spellLevel);
        int minLevel = abstractSpell.getMinLevelForRarity(rarity);
        SyncedRarityData rarityData = (SyncedRarityData)player.getData(DataAttachmentRegistry.RARITY_DATA);
        SpellRarity currentRarity = rarityData.getRarity();
        if (currentRarity == null) {
            return this.irons_Restrictions$imbuedChecks(abstractSpell, player);
        }
        if (minLevel <= abstractSpell.getMinLevelForRarity(currentRarity)) {
            return true;
        }
        return this.irons_Restrictions$imbuedChecks(abstractSpell, player);
    }

    @Unique
    private boolean irons_Restrictions$imbuedChecks(AbstractSpell spell, Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.getItemInHand(hand);
            if (!this.irons_Restrictions$isSpellImbued(held, spell)) continue;
            return true;
        }
        for (ItemStack armorItem : player.getArmorSlots()) {
            if (!this.irons_Restrictions$isSpellImbued(armorItem, spell)) continue;
            return true;
        }
        Optional curiosHandlerOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosHandlerOpt.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)curiosHandlerOpt.get();
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    ItemStack curioStack = ((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i);
                    if (!this.irons_Restrictions$isSpellImbued(curioStack, spell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Unique
    private boolean irons_Restrictions$isSpellImbued(ItemStack itemStack, AbstractSpell abstractSpell) {
        ISpellContainer container;
        if (itemStack.getItem() instanceof SpellBook || itemStack.getItem() instanceof Scroll || Config.ImbuedItemsRequireLearning.isTrue()) {
            return false;
        }
        if (ISpellContainer.isSpellContainer((ItemStack)itemStack) && (container = ISpellContainer.get((ItemStack)itemStack)) != null) {
            for (SpellSlot spellSlot : container.getAllSpells()) {
                if (spellSlot.getSpell() != abstractSpell) continue;
                return true;
            }
        }
        return false;
    }
}

