/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.compat.entityjs.entity;

import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.squoshi.irons_spells_js.compat.entityjs.entity.builder.SpellCastingMobJSBuilder;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.Cast;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpellCastingMobJS
extends PathfinderMob
implements IAnimatableJS,
IMagicEntity {
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.defineId(SpellCastingMobJS.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.defineId(SpellCastingMobJS.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final MagicData playerMagicData = new MagicData(true);
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(IronsSpellbooks.id((String)"potion_slowdown"), -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    @Nullable
    private SpellData castingSpell;
    private final HashMap<String, AbstractSpell> spells = Maps.newHashMap();
    private int drinkTime;
    public boolean hasUsedSingleAttack;
    private AbstractSpell lastCastSpellType = SpellRegistry.none();
    private AbstractSpell instantCastSpellType = SpellRegistry.none();
    private final SpellCastingMobJSBuilder builder;
    private final AnimatableInstanceCache animationFactory;
    public final PartEntityJS<?>[] partEntities;
    protected boolean thisJumping;

    public String entityName() {
        return this.getType().toString();
    }

    public SpellCastingMobJS(SpellCastingMobJSBuilder builder, EntityType<SpellCastingMobJS> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
        this.thisJumping = false;
        this.builder = builder;
        this.animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        ArrayList<PartEntityJS> tempPartEntities = new ArrayList<PartEntityJS>();
        for (ContextUtils.PartEntityParams params : builder.partEntityParamsList) {
            PartEntityJS partEntity = new PartEntityJS((LivingEntity)this, params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
        this.jumpControl = this.createJumpControl();
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
        this.navigation = this.createNavigation(pLevel);
    }

    private MoveControl createMoveControl() {
        if (this.builder.setMoveControl != null) {
            Object obj = this.builder.setMoveControl.apply(this);
            if (obj != null) {
                return (MoveControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setMoveControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a MoveControl object. Defaulting to super method."));
        }
        return new MoveControl((Mob)this);
    }

    private JumpControl createJumpControl() {
        if (this.builder.setJumpControl != null) {
            Object obj = this.builder.setJumpControl.apply(this);
            if (obj != null) {
                return (JumpControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setJumpControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a JumpControl object. Defaulting to super method."));
        }
        return new JumpControl((Mob)this);
    }

    protected LookControl createLookControl() {
        if (this.builder.setLookControl != null) {
            Object obj = this.builder.setLookControl.apply(this);
            if (obj != null) {
                return (LookControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setLookControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a LookControl object. Defaulting to super method."));
        }
        return new LookControl((Mob)this){

            protected boolean resetXRotOnTick() {
                return SpellCastingMobJS.this.getTarget() == null;
            }
        };
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CANCEL_CAST, (Object)false);
        builder.define(DATA_DRINKING_POTION, (Object)false);
    }

    protected void defineSynchedData() {
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.entityData.get(DATA_DRINKING_POTION);
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean bool) {
        this.hasUsedSingleAttack = bool;
    }

    protected void setDrinkingPotion(boolean drinkingPotion) {
        this.entityData.set(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public void startDrinkingPotion() {
        if (!this.level().isClientSide) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            attributeinstance.removeModifier(SPEED_MODIFIER_DRINKING);
            attributeinstance.addTransientModifier(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.heal(Math.min(Math.max(10.0f, this.getMaxHealth() / 10.0f), this.getMaxHealth() / 4.0f));
        this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_DRINKING);
        if (!this.isSilent()) {
            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_DRINK, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (this.level().isClientSide && pKey.id() == DATA_CANCEL_CAST.id()) {
            this.cancelCast();
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        pCompound.putBoolean("usedSpecial", this.hasUsedSingleAttack);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        if (syncedSpellData.isCasting()) {
            AbstractSpell spell = SpellRegistry.getSpell((String)syncedSpellData.getCastingSpellId());
            this.initiateCastSpell(spell, syncedSpellData.getCastingSpellLevel());
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.getBoolean("usedSpecial");
    }

    public void cancelCast() {
        if (this.builder.onCancelledCast != null) {
            this.builder.onCancelledCast.accept(this);
        }
        if (this.isCasting()) {
            if (!this.level().isClientSide) {
                this.entityData.set(DATA_CANCEL_CAST, (Object)((Boolean)this.entityData.get(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.level().isClientSide) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void startAutoSpinAttack(int pAttackTicks) {
        this.autoSpinAttackTicks = pAttackTicks;
        if (!this.level().isClientSide) {
            this.setLivingEntityFlag(4, true);
        }
        this.setYRot((float)(Math.atan2(this.getDeltaMovement().x, this.getDeltaMovement().z) * 57.2957763671875));
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (this.level().isClientSide) {
            boolean isCasting = this.playerMagicData.isCasting();
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.castingSpell = this.playerMagicData.getCastingSpell();
            if (this.castingSpell != null) {
                if (!this.playerMagicData.isCasting() && isCasting) {
                    this.castComplete();
                } else if (this.playerMagicData.isCasting() && !isCasting) {
                    AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
                    this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
                    if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                        this.instantCastSpellType = this.castingSpell.getSpell();
                        this.castingSpell.getSpell().onClientPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                        this.castComplete();
                    }
                }
            }
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isDrinkingPotion()) {
            if (this.drinkTime-- <= 0) {
                this.finishDrinkingPotion();
            } else if (this.drinkTime % 4 == 0 && !this.isSilent()) {
                this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_DRINK, this.getSoundSource(), 1.0f, Utils.random.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.castingSpell != null) {
            this.playerMagicData.handleCastDuration();
            if (this.playerMagicData.isCasting()) {
                this.castingSpell.getSpell().onServerCastTick(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
            }
            this.forceLookAtTarget(this.getTarget());
            if (this.playerMagicData.getCastDurationRemaining() <= 0) {
                if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                    this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
                }
                this.castComplete();
            } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
                this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
        } else {
            this.castingSpell = new SpellData(spell, spellLevel);
            if (this.getTarget() != null) {
                this.forceLookAtTarget(this.getTarget());
            }
            if (!this.level().isClientSide && !this.castingSpell.getSpell().checkPreCastConditions(this.level(), spellLevel, (LivingEntity)this, this.playerMagicData)) {
                this.castingSpell = null;
            } else {
                if (spell != SpellRegistry.TELEPORT_SPELL.get() && spell != SpellRegistry.FROST_STEP_SPELL.get()) {
                    if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
                        this.setTeleportLocationBehindTarget(3);
                    } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
                        this.setBurningDashDirectionData();
                    }
                } else {
                    this.setTeleportLocationBehindTarget(10);
                }
                this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB, SpellSelectionManager.MAINHAND);
                if (!this.level().isClientSide) {
                    this.castingSpell.getSpell().onServerPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
                }
            }
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        if (this.builder.isCasting != null) {
            Object obj = this.builder.isCasting.apply(this);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[KubeJS Irons Spells]: Invalid return value for isCasting from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + this.playerMagicData.isCasting()));
        }
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.getTarget();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.getLookAngle().normalize().scale((double)(-distance));
            Vec3 pos = target.position();
            Vec3 teleportPos = rotation.add(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).multiply(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.level(), (Vec3)target.position().subtract(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).yRot(-(target.getYRot() + (float)(i * 45)) * ((float)Math.PI / 180))).add(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.x, teleportPos.y + (double)0.1f, teleportPos.z);
                AABB reposBB = this.getBoundingBox().move(teleportPos.subtract(this.position()));
                if (this.level().collidesWithSuffocatingBlock((Entity)this, reposBB.inflate((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.getX() - this.getX();
            double d2 = target.getZ() - this.getZ();
            double d1 = target.getEyeY() - this.getEyeY();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
            this.setXRot(f1 % 360.0f);
            this.setYRot(f % 360.0f);
        }
    }

    private void addClientSideParticles() {
        double d0 = 0.4;
        double d1 = 0.3;
        double d2 = 0.35;
        float f = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
        float f1 = Mth.cos((float)f);
        float f2 = Mth.sin((float)f);
        this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getX() + (double)f1 * 0.6, this.getY() + 1.8, this.getZ() + (double)f2 * 0.6, d0, d1, d2);
        this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getX() - (double)f1 * 0.6, this.getY() + 1.8, this.getZ() - (double)f2 * 0.6, d0, d1, d2);
    }

    public void setId(int entityId) {
        super.setId(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.setId(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.getYRot(), partEntity.getXRot());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce((String)("Part with name " + partName + " not found for entity: " + this.entityName()));
    }

    public boolean isMultipartEntity() {
        return this.partEntities != null;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
    }

    public PartEntity<?>[] getParts() {
        return Objects.requireNonNullElseGet(this.partEntities, () -> new PartEntity[0]);
    }

    public BaseLivingEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    public Brain.Provider<?> brainProvider() {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post((KubeEvent)event, (Object)this.getTypeId());
            return event.provide();
        }
        return super.brainProvider();
    }

    protected Brain<SpellCastingMobJS> makeBrain(Dynamic<?> p_21069_) {
        if (EventHandlers.buildBrain.hasListeners()) {
            Brain brain = (Brain)Cast.to((Object)this.brainProvider().makeBrain(p_21069_));
            EventHandlers.buildBrain.post((KubeEvent)new BuildBrainEventJS(brain), (Object)this.getTypeId());
            return brain;
        }
        return (Brain)Cast.to((Object)super.makeBrain(p_21069_));
    }

    protected void registerGoals() {
        if (EventHandlers.addGoalTargets.hasListeners()) {
            EventHandlers.addGoalTargets.post((KubeEvent)new AddGoalTargetsEventJS((Mob)this, this.targetSelector), (Object)this.getTypeId());
        }
        if (EventHandlers.addGoalSelectors.hasListeners()) {
            EventHandlers.addGoalSelectors.post((KubeEvent)new AddGoalSelectorsEventJS((Mob)this, this.goalSelector), (Object)this.getTypeId());
        }
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (this.builder != null && this.builder.onHurtTarget != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHurtTarget, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHurtTarget."));
        }
        return super.doHurtTarget(pEntity);
    }

    public void onJump() {
        if (this.builder.onLivingJump != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingJump, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingJump."));
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.canJump() && this.onGround() && this.getNavigation().isInProgress() && this.shouldJump()) {
            this.jump();
        }
        if (this.builder.aiStep != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.aiStep, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: aiStep."));
        }
    }

    protected void tickDeath() {
        if (this.builder.tickDeath != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tickDeath, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tickDeath."));
        } else {
            super.tickDeath();
        }
    }

    public void setTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        super.setTarget(target);
        if (this.builder.onTargetChanged != null) {
            ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(target, (Mob)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onTargetChanged, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onTargetChanged."));
        }
    }

    public void ate() {
        super.ate();
        if (this.builder.ate != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.ate, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: ate."));
        }
    }

    protected PathNavigation createNavigation(Level pLevel) {
        if (this.builder == null || this.builder.createNavigation == null) {
            return new GroundPathNavigation((Mob)this, pLevel);
        }
        ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (LivingEntity)this);
        Object obj = this.builder.createNavigation.apply(context);
        if (obj instanceof PathNavigation) {
            PathNavigation p = (PathNavigation)obj;
            return p;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for createNavigation from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be PathNavigation. Defaulting to super method."));
        return new GroundPathNavigation((Mob)this, pLevel);
    }

    public boolean canBeLeashed() {
        if (this.builder.canBeLeashed != null) {
            Object obj = this.builder.canBeLeashed.apply(this);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeLeashed()));
        }
        return super.canBeLeashed();
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        if (this.builder.removeWhenFarAway == null) {
            return super.removeWhenFarAway(pDistanceToClosestPlayer);
        }
        ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (LivingEntity)this);
        Object obj = this.builder.removeWhenFarAway.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.removeWhenFarAway(pDistanceToClosestPlayer)));
        return super.removeWhenFarAway(pDistanceToClosestPlayer);
    }

    protected double followLeashSpeed() {
        return Objects.requireNonNullElseGet(this.builder.followLeashSpeed, () -> super.followLeashSpeed());
    }

    public int getAmbientSoundInterval() {
        if (this.builder.ambientSoundInterval != null) {
            return (Integer)this.builder.ambientSoundInterval;
        }
        return super.getAmbientSoundInterval();
    }

    public boolean canJump() {
        return Objects.requireNonNullElse(this.builder.canJump, true);
    }

    public void jump() {
        double jumpPower = this.getJumpPower() + this.getJumpBoostPower();
        Vec3 currentVelocity = this.getDeltaMovement();
        this.setDeltaMovement(currentVelocity.x, jumpPower, currentVelocity.z);
        this.hasImpulse = true;
        if (this.isSprinting()) {
            float yawRadians = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add(-Math.sin(yawRadians) * 0.2, 0.0, Math.cos(yawRadians) * 0.2));
        }
        this.hasImpulse = true;
        this.onJump();
        CommonHooks.onLivingJump((LivingEntity)this);
    }

    public boolean shouldJump() {
        BlockPos forwardPos = this.blockPosition().relative(this.getDirection());
        return this.level().loadedAndEntityCanStandOn(forwardPos, (Entity)this) && (double)this.maxUpStep() < this.level().getBlockState(forwardPos).getShape((BlockGetter)this.level(), forwardPos).max(Direction.Axis.Y);
    }

    public HumanoidArm getMainArm() {
        if (this.builder.mainArm != null) {
            return (HumanoidArm)this.builder.mainArm;
        }
        return super.getMainArm();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader levelReader) {
        if (this.builder.walkTargetValue == null) {
            return super.getWalkTargetValue(pos, levelReader);
        }
        ContextUtils.EntityBlockPosLevelContext context = new ContextUtils.EntityBlockPosLevelContext(pos, levelReader, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.walkTargetValue.apply(context), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for walkTargetValue from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.walkTargetValue.apply(context)) + ". Must be a float. Defaulting to " + super.getWalkTargetValue(pos, levelReader)));
        return super.getWalkTargetValue(pos, levelReader);
    }

    protected boolean shouldStayCloseToLeashHolder() {
        if (this.builder.shouldStayCloseToLeashHolder == null) {
            return super.shouldStayCloseToLeashHolder();
        }
        Object value = this.builder.shouldStayCloseToLeashHolder.apply(this);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldStayCloseToLeashHolder from entity: " + this.entityName() + ". Value: " + String.valueOf(value) + ". Must be a boolean. Defaulting to " + super.shouldStayCloseToLeashHolder()));
        return super.shouldStayCloseToLeashHolder();
    }

    public boolean canFireProjectileWeaponPredicate(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeaponPredicate != null) {
            ContextUtils.EntityProjectileWeaponContext context = new ContextUtils.EntityProjectileWeaponContext(projectileWeapon, (LivingEntity)this);
            Object obj = this.builder.canFireProjectileWeaponPredicate.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canFireProjectileWeaponPredicate from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to false."));
        }
        return false;
    }

    public boolean canFireProjectileWeapons(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeapon != null) {
            return this.builder.canFireProjectileWeapon.test(projectileWeapon.getDefaultInstance()) && projectileWeapon instanceof ProjectileWeaponItem;
        }
        return super.canFireProjectileWeapon(projectileWeapon);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeapon) {
        if (this.canFireProjectileWeapons(projectileWeapon) || this.canFireProjectileWeaponPredicate(projectileWeapon)) {
            return this.canFireProjectileWeapons(projectileWeapon) && this.canFireProjectileWeaponPredicate(projectileWeapon);
        }
        return super.canFireProjectileWeapon(projectileWeapon);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getAmbientSound() {
        if (this.builder.setAmbientSound != null) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setAmbientSound);
        }
        return super.getAmbientSound();
    }

    public boolean canHoldItem(ItemStack stack) {
        if (this.builder.canHoldItem != null) {
            ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(stack, (LivingEntity)this);
            Object obj = this.builder.canHoldItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canHoldItem(stack)));
        }
        return super.canHoldItem(stack);
    }

    protected boolean shouldDespawnInPeaceful() {
        return Objects.requireNonNullElseGet(this.builder.shouldDespawnInPeaceful, () -> super.shouldDespawnInPeaceful());
    }

    public boolean isPersistenceRequired() {
        return Objects.requireNonNullElseGet(this.builder.isPersistenceRequired, () -> super.isPersistenceRequired());
    }

    public AABB getAttackBoundingBox() {
        if (this.builder.getAttackBoundingBox != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.getAttackBoundingBox.apply(this), (String)"aabb");
            if (obj != null) {
                return (AABB)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for getAttackBoundingBox from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.getAttackBoundingBox.apply(this)) + ". Must be an AABB. Defaulting to " + String.valueOf(super.getAttackBoundingBox())));
        }
        return super.getAttackBoundingBox();
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (this.builder.isAlliedTo != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            try {
                Object obj = this.builder.isAlliedTo.apply(context);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    return b;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAlliedTo(pEntity)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Must be a boolean. Defaulting to " + super.isAlliedTo(pEntity)), (Throwable)e);
                return super.isAlliedTo(pEntity);
            }
        }
        return super.isAlliedTo(pEntity);
    }

    public void travel(Vec3 pTravelVector) {
        LivingEntity livingentity = this.getControllingPassenger();
        if (this.isAlive() && this.isVehicle() && this.builder.canSteer.booleanValue() && livingentity != null) {
            if (this.getControllingPassenger() instanceof Player && this.builder.mountJumpingEnabled) {
                if (this.ableToJump()) {
                    this.setThisJumping(true);
                }
                if (this.thisJumping) {
                    this.setThisJumping(false);
                    double jumpPower = this.getJumpPower() + this.getJumpBoostPower();
                    Vec3 currentVelocity = this.getDeltaMovement();
                    double newVelocityX = currentVelocity.x;
                    double newVelocityY = currentVelocity.y + jumpPower;
                    double newVelocityZ = currentVelocity.z;
                    this.setDeltaMovement(newVelocityX, newVelocityY, newVelocityZ);
                    this.onJump();
                    CommonHooks.onLivingJump((LivingEntity)this);
                }
            }
            LivingEntity passenger = this.getControllingPassenger();
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setYRot(passenger.getYRot());
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float x = passenger.xxa * 0.5f;
            float z = passenger.zza;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
            super.travel(new Vec3((double)x, pTravelVector.y, (double)z));
        } else {
            super.travel(pTravelVector);
        }
        if (this.builder.travel != null) {
            ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.travel, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: travel."));
        }
    }

    public void tick() {
        super.tick();
        if (this.builder.tick != null && !this.level().isClientSide()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tick."));
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder.onAddedToWorld != null && !this.level().isClientSide()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onAddedToWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld."));
        }
    }

    protected void doAutoAttackOnTouch(@NotNull LivingEntity target) {
        super.doAutoAttackOnTouch(target);
        if (this.builder.doAutoAttackOnTouch != null) {
            ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext((LivingEntity)this, target);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.doAutoAttackOnTouch, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: doAutoAttackOnTouch."));
        }
    }

    protected int decreaseAirSupply(int p_21303_) {
        if (this.builder.onDecreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onDecreaseAirSupply, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply."));
        }
        return super.decreaseAirSupply(p_21303_);
    }

    protected int increaseAirSupply(int p_21307_) {
        if (this.builder.onIncreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onIncreaseAirSupply, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onIncreaseAirSupply."));
        }
        return super.increaseAirSupply(p_21307_);
    }

    protected void blockedByShield(@NotNull LivingEntity p_21246_) {
        super.blockedByShield(p_21246_);
        if (this.builder.onBlockedByShield != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, p_21246_);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onBlockedByShield, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply."));
        }
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack previous, ItemStack current) {
        super.onEquipItem(slot, previous, current);
        if (this.builder.onEquipItem != null) {
            ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(slot, previous, current, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEquipItem, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEquipItem."));
        }
    }

    public void onEffectAdded(@NotNull MobEffectInstance effectInstance, @org.jetbrains.annotations.Nullable Entity entity) {
        if (this.builder.onEffectAdded != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEffectAdded, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectAdded."));
        } else {
            super.onEffectAdded(effectInstance, entity);
        }
    }

    protected void onEffectRemoved(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.onEffectRemoved != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEffectRemoved, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectRemoved."));
        } else {
            super.onEffectRemoved(effectInstance);
        }
    }

    public void heal(float amount) {
        super.heal(amount);
        if (this.builder.onLivingHeal != null) {
            ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext((LivingEntity)this, amount);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingHeal, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingHeal."));
        }
    }

    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        if (this.builder.onDeath != null) {
            ContextUtils.DeathContext context = new ContextUtils.DeathContext((LivingEntity)this, damageSource);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onDeath, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onDeath."));
        }
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean allowDrops) {
        if (this.builder.dropCustomDeathLoot != null) {
            ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(serverLevel, damageSource, allowDrops, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.dropCustomDeathLoot, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: dropCustomDeathLoot."));
        } else {
            super.dropCustomDeathLoot(serverLevel, damageSource, allowDrops);
        }
    }

    protected void onFlap() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onFlap, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap."));
        }
        super.onFlap();
    }

    public boolean ableToJump() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.getInstance().options.keyJump.isDown() && this.onGround();
        }
        return false;
    }

    public void setThisJumping(boolean value) {
        this.thisJumping = value;
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        this.triggerAnim(controllerName, animName);
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.CollidingEntityContext context = new ContextUtils.CollidingEntityContext((LivingEntity)this, pEntity);
            try {
                Object obj = this.builder.canCollideWith.apply(context);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    return b;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canCollideWith. Defaulting to " + super.canCollideWith(pEntity)), (Throwable)e);
                return super.canCollideWith(pEntity);
            }
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), (String)"float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + String.valueOf(this.builder.get()) + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockSpeedFactor()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: blockSpeedFactor. Defaulting to " + super.getBlockSpeedFactor()), (Throwable)e);
            }
        }
        return super.getBlockSpeedFactor();
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), (String)"float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: setBlockJumpFactor. Defaulting to " + super.getBlockJumpFactor()), (Throwable)e);
            }
        }
        return super.getBlockJumpFactor();
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger != null) {
            ContextUtils.PassengerEntityContext context = new ContextUtils.PassengerEntityContext(entity, (LivingEntity)this);
            try {
                Object obj = this.builder.canAddPassenger.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAddPassenger. Defaulting to " + super.canAddPassenger(entity)), (Throwable)e);
            }
        }
        return super.canAddPassenger(entity);
    }

    protected boolean shouldDropLoot() {
        if (this.builder.shouldDropLoot != null) {
            try {
                Object obj = this.builder.shouldDropLoot.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.shouldDropLoot()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldDropLoot. Defaulting to " + super.shouldDropLoot()), (Throwable)e);
            }
        }
        return super.shouldDropLoot();
    }

    protected boolean isAffectedByFluids() {
        if (this.builder.isAffectedByFluids != null) {
            try {
                Object obj = this.builder.isAffectedByFluids.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAffectedByFluids()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAffectedByFluids. Defaulting to " + super.isAffectedByFluids()), (Throwable)e);
            }
        }
        return super.isAffectedByFluids();
    }

    protected boolean isImmobile() {
        if (this.builder.isImmobile != null) {
            try {
                Object obj = this.builder.isImmobile.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isImmobile()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isImmobile. Defaulting to " + super.isImmobile()), (Throwable)e);
            }
        }
        return super.isImmobile();
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            try {
                Object obj = this.builder.isFlapping.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isFlapping. Defaulting to " + super.isFlapping()), (Throwable)e);
            }
        }
        return super.isFlapping();
    }

    public int calculateFallDamage(float fallDistance, float pDamageMultiplier) {
        if (this.builder.calculateFallDamage != null) {
            ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(fallDistance, pDamageMultiplier, (LivingEntity)this);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.calculateFallDamage.apply(context), (String)"integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.calculateFallDamage.apply(context)) + ". Must be an int, defaulting to " + super.calculateFallDamage(fallDistance, pDamageMultiplier)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: calculateFallDamage. Defaulting to " + super.calculateFallDamage(fallDistance, pDamageMultiplier)), (Throwable)e);
            }
        }
        return super.calculateFallDamage(fallDistance, pDamageMultiplier);
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), (String)"float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply(this)) + ". Must be a float, defaulting to " + super.nextStep()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: nextStep. Defaulting to " + super.nextStep()), (Throwable)e);
            }
        }
        return super.nextStep();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource p_21239_) {
        if (this.builder.setHurtSound != null) {
            ContextUtils.HurtContext context = new ContextUtils.HurtContext((LivingEntity)this, p_21239_);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setHurtSound.apply(context), (String)"resourcelocation");
                if (obj != null) {
                    return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)obj));
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setHurtSound from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setHurtSound.apply(context)) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\""));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: setHurtSound. Defaulting to \"minecraft:entity.generic.hurt\""), (Throwable)e);
            }
        }
        return super.getHurtSound(p_21239_);
    }

    public boolean canAttackType(@NotNull EntityType<?> entityType) {
        if (this.builder.canAttackType != null) {
            ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext((LivingEntity)this, entityType);
            try {
                Object obj = this.builder.canAttackType.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canAttackType(entityType)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAttackType. Defaulting to " + super.canAttackType(entityType)), (Throwable)e);
            }
        }
        return super.canAttackType(entityType);
    }

    public float getScale() {
        if (this.builder.scale != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.scale.apply(this), (String)"float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for scale from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.scale.apply(this)) + ". Must be a float. Defaulting to " + super.getScale()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: scale. Defaulting to " + super.getScale()), (Throwable)e);
            }
        }
        return super.getScale();
    }

    public boolean shouldDropExperience() {
        if (this.builder.shouldDropExperience != null) {
            try {
                Object obj = this.builder.shouldDropExperience.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.shouldDropExperience()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldDropExperience. Defaulting to " + super.shouldDropExperience()), (Throwable)e);
            }
        }
        return super.shouldDropExperience();
    }

    public double getVisibilityPercent(@org.jetbrains.annotations.Nullable Entity p_20969_) {
        if (this.builder.visibilityPercent != null) {
            ContextUtils.VisualContext context = new ContextUtils.VisualContext(p_20969_, (LivingEntity)this);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.visibilityPercent.apply(context), (String)"double");
                if (obj != null) {
                    return (Double)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for visibilityPercent from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.visibilityPercent.apply(context)) + ". Must be a double. Defaulting to " + super.getVisibilityPercent(p_20969_)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: visibilityPercent. Defaulting to " + super.getVisibilityPercent(p_20969_)), (Throwable)e);
            }
        }
        return super.getVisibilityPercent(p_20969_);
    }

    public boolean canAttack(@NotNull LivingEntity entity) {
        if (this.builder.canAttack != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, entity);
            try {
                Object obj = this.builder.canAttack.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj != false && super.canAttack(entity);
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canAttack(entity)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAttack. Defaulting to " + super.canAttack(entity)), (Throwable)e);
            }
        }
        return super.canAttack(entity);
    }

    public boolean canBeAffected(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.canBeAffected != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            try {
                Object result = this.builder.canBeAffected.apply(context);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityName() + ". Value: " + String.valueOf(result) + ". Must be a boolean. Defaulting to " + super.canBeAffected(effectInstance)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canBeAffected. Defaulting to " + super.canBeAffected(effectInstance)), (Throwable)e);
            }
        }
        return super.canBeAffected(effectInstance);
    }

    public boolean isInvertedHealAndHarm() {
        if (this.builder.invertedHealAndHarm != null) {
            try {
                Object obj = this.builder.invertedHealAndHarm.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvertedHealAndHarm()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: invertedHealAndHarm. Defaulting to " + super.isInvertedHealAndHarm()), (Throwable)e);
            }
        }
        return super.isInvertedHealAndHarm();
    }

    public boolean onClimbable() {
        if (this.builder.onClimbable != null) {
            try {
                Object obj = this.builder.onClimbable.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super.onClimbable(): " + super.onClimbable()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: onClimbable. Defaulting to " + super.onClimbable()), (Throwable)e);
            }
        }
        return super.onClimbable();
    }

    public float getJumpBoostPower() {
        if (this.builder.jumpBoostPower != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.jumpBoostPower.apply(this), (String)"float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.jumpBoostPower.apply(this)) + ". Must be a float. Defaulting to " + super.getJumpBoostPower()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: jumpBoostPower. Defaulting to " + super.getJumpBoostPower()), (Throwable)e);
            }
        }
        return super.getJumpBoostPower();
    }

    public boolean canStandOnFluid(@NotNull FluidState fluidState) {
        if (this.builder.canStandOnFluid != null) {
            ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext((LivingEntity)this, fluidState);
            try {
                Object obj = this.builder.canStandOnFluid.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canStandOnFluid(fluidState)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canStandOnFluid. Defaulting to " + super.canStandOnFluid(fluidState)), (Throwable)e);
            }
        }
        return super.canStandOnFluid(fluidState);
    }

    public boolean isSensitiveToWater() {
        if (this.builder.isSensitiveToWater != null) {
            try {
                Object obj = this.builder.isSensitiveToWater.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isSensitiveToWater()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isSensitiveToWater. Defaulting to " + super.isSensitiveToWater()), (Throwable)e);
            }
        }
        return super.isSensitiveToWater();
    }

    public boolean hasLineOfSight(@NotNull Entity entity) {
        if (this.builder.hasLineOfSight != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(entity, (LivingEntity)this);
            try {
                Object obj = this.builder.hasLineOfSight.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.hasLineOfSight(entity)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: hasLineOfSight. Defaulting to " + super.hasLineOfSight(entity)), (Throwable)e);
            }
        }
        return super.hasLineOfSight(entity);
    }

    public boolean isAffectedByPotions() {
        if (this.builder.isAffectedByPotions != null) {
            try {
                Object obj = this.builder.isAffectedByPotions.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAffectedByPotions()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAffectedByPotions. Defaulting to " + super.isAffectedByPotions()), (Throwable)e);
            }
        }
        return super.isAffectedByPotions();
    }

    public boolean attackable() {
        if (this.builder.isAttackable != null) {
            try {
                Object obj = this.builder.isAttackable.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.attackable()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAttackable. Defaulting to " + super.attackable()), (Throwable)e);
            }
        }
        return super.attackable();
    }

    public boolean canTakeItem(@NotNull ItemStack itemStack) {
        if (this.builder.canTakeItem != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, this.level());
            try {
                Object obj = this.builder.canTakeItem.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTakeItem(itemStack)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canTakeItem. Defaulting to " + super.canTakeItem(itemStack)), (Throwable)e);
            }
        }
        return super.canTakeItem(itemStack);
    }

    public boolean isSleeping() {
        if (this.builder.isSleeping != null) {
            try {
                Object obj = this.builder.isSleeping.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isSleeping()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isSleeping. Defaulting to " + super.isSleeping()), (Throwable)e);
            }
        }
        return super.isSleeping();
    }

    public boolean shouldRiderFaceForward(@NotNull Player player) {
        if (this.builder.shouldRiderFaceForward != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(player, (LivingEntity)this);
            try {
                Object obj = this.builder.shouldRiderFaceForward.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for shouldRiderFaceForward from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.shouldRiderFaceForward(player)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldRiderFaceForward. Defaulting to " + super.shouldRiderFaceForward(player)), (Throwable)e);
            }
        }
        return super.shouldRiderFaceForward(player);
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            try {
                Object obj = this.builder.canFreeze.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canFreeze. Defaulting to " + super.canFreeze()), (Throwable)e);
            }
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            try {
                Object obj = this.builder.isFreezing.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isFreezing. Defaulting to " + super.isFreezing()), (Throwable)e);
            }
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null && !this.level().isClientSide()) {
            try {
                Object obj = this.builder.isCurrentlyGlowing.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: isCurrentlyGlowing. Defaulting to " + super.isCurrentlyGlowing()), (Throwable)e);
            }
        }
        return super.isCurrentlyGlowing();
    }

    public boolean canDisableShield() {
        if (this.builder.canDisableShield != null) {
            try {
                Object obj = this.builder.canDisableShield.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canDisableShield()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canDisableShield. Defaulting to " + super.canDisableShield()), (Throwable)e);
            }
        }
        return super.canDisableShield();
    }

    protected int getBaseExperienceReward() {
        if (this.builder.experienceReward != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.experienceReward.apply(this), (String)"integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for experienceReward from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.experienceReward.apply(this)) + ". Must be an integer. Defaulting to " + super.getBaseExperienceReward()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: experienceReward. Defaulting to " + super.getBaseExperienceReward()), (Throwable)e);
            }
        }
        return super.getBaseExperienceReward();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            try {
                Object obj = this.builder.dampensVibrations.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: dampensVibrations. Defaulting to " + super.dampensVibrations()), (Throwable)e);
            }
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            try {
                Object obj = this.builder.showVehicleHealth.apply(this);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: showVehicleHealth. Defaulting to " + super.showVehicleHealth()), (Throwable)e);
            }
        }
        return super.showVehicleHealth();
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            try {
                Object obj = this.builder.canChangeDimensions.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canChangeDimensions. Defaulting to " + super.canChangeDimensions(to, from)), (Throwable)e);
            }
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.MayInteractContext context = new ContextUtils.MayInteractContext(p_146843_, p_146844_, (LivingEntity)this);
            try {
                Object obj = this.builder.mayInteract.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: mayInteract. Defaulting to " + super.mayInteract(p_146843_, p_146844_)), (Throwable)e);
            }
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.CanTrampleContext context = new ContextUtils.CanTrampleContext(state, pos, fallDistance, (LivingEntity)this);
            try {
                Object obj = this.builder.canTrample.apply(context);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance)));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: canTrample. Defaulting to " + super.canTrample(state, pos, fallDistance)), (Throwable)e);
            }
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), (String)"integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply(this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable((String)("[EntityJS]: Exception in " + this.entityName() + " builder for field: setMaxFallDistance. Defaulting to " + super.getMaxFallDistance()), (Throwable)e);
            }
        }
        return super.getMaxFallDistance();
    }

    protected float getSoundVolume() {
        return Objects.requireNonNullElseGet(this.builder.setSoundVolume, () -> Float.valueOf(super.getSoundVolume())).floatValue();
    }

    protected float getWaterSlowDown() {
        return Objects.requireNonNullElseGet(this.builder.setWaterSlowDown, () -> Float.valueOf(super.getWaterSlowDown())).floatValue();
    }

    public boolean isPushable() {
        return this.builder.isPushable;
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.positionRider, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider."));
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean isAlwaysExperienceDropper() {
        return this.builder.isAlwaysExperienceDropper;
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    protected SoundEvent getDeathSound() {
        if (this.builder.setDeathSound == null) {
            return super.getDeathSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setDeathSound));
    }

    @NotNull
    public LivingEntity.Fallsounds getFallSounds() {
        if (this.builder.fallSounds != null) {
            return new LivingEntity.Fallsounds(Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.smallFallSound)), Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.largeFallSound)));
        }
        return super.getFallSounds();
    }

    @NotNull
    public SoundEvent getEatingSound(@NotNull ItemStack itemStack) {
        if (this.builder.eatingSound != null) {
            return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.eatingSound));
        }
        return super.getEatingSound(itemStack);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onLivingFall != null) {
            ContextUtils.EntityFallDamageContext context = new ContextUtils.EntityFallDamageContext((LivingEntity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLivingFall, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall."));
        }
        return super.causeFallDamage(distance, damageMultiplier, damageSource);
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onSprint, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint."));
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStopRiding, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding."));
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onRemovePassenger, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger."));
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.rideTick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick."));
        }
    }

    public void onItemPickup(@NotNull ItemEntity p_21054_) {
        super.onItemPickup(p_21054_);
        if (this.builder.onItemPickup != null) {
            ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext((LivingEntity)this, p_21054_);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onItemPickup, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onItemPickup."));
        }
    }

    public void onEnterCombat() {
        if (this.builder.onEnterCombat != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEnterCombat, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEnterCombat."));
        } else {
            super.onEnterCombat();
        }
    }

    public void onLeaveCombat() {
        if (this.builder.onLeaveCombat != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onLeaveCombat, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLeaveCombat."));
        }
        super.onLeaveCombat();
    }

    public void startSleeping(@NotNull BlockPos blockPos) {
        if (this.builder.onStartSleeping != null) {
            ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext((LivingEntity)this, blockPos);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStartSleeping, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStartSleeping."));
        }
        super.startSleeping(blockPos);
    }

    public void stopSleeping() {
        if (this.builder.onStopSleeping != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStopSleeping, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStopSleeping."));
        }
        super.stopSleeping();
    }

    public ItemStack eat(Level level, ItemStack itemStack, FoodProperties properties) {
        if (this.builder.eat != null) {
            ContextUtils.FoodItemLevelContext context = new ContextUtils.FoodItemLevelContext((LivingEntity)this, itemStack, level, properties);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.eat, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: eat."));
            return itemStack;
        }
        return super.eat(level, itemStack);
    }

    public void onClientRemoval() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onClientRemoval, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval."));
        }
        super.onClientRemoval();
    }

    public void actuallyHurt(DamageSource pDamageSource, float pDamageAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHurt, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt."));
        }
        super.actuallyHurt(pDamageSource, pDamageAmount);
    }

    public void lavaHurt() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lavaHurt, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt."));
        }
        super.lavaHurt();
    }

    public void playerTouch(Player p_20081_) {
        if (this.builder.playerTouch != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(p_20081_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.playerTouch, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch."));
        } else {
            super.playerTouch(p_20081_);
        }
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.ThunderHitContext context = new ContextUtils.ThunderHitContext(p_19927_, p_19928_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.thunderHit, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit."));
        }
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.DamageContext context = new ContextUtils.DamageContext((LivingEntity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_)));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onRemovedFromWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld."));
        }
        super.onRemovedFromLevel();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lerpTo, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo."));
        }
    }
}

