/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.compat.entityjs.entity;

import com.squoshi.irons_spells_js.compat.entityjs.entity.builder.SpellProjectileJSBuilder;
import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IProjectileEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SpellProjectileJS
extends AbstractMagicProjectile
implements IProjectileEntityJS,
AntiMagicSusceptible {
    public SpellProjectileJSBuilder builder;
    private float damage;
    private float speed = 0.0f;

    public SpellProjectileJS(SpellProjectileJSBuilder builder, EntityType<? extends AbstractMagicProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
    }

    public SpellProjectileJS(EntityType<? extends AbstractMagicProjectile> entityType, Level levelIn, LivingEntity shooter) {
        super(entityType, levelIn);
        this.setOwner((Entity)shooter);
    }

    public ProjectileEntityBuilder<?> getProjectileBuilder() {
        return this.builder;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void trailParticles() {
        if (this.builder.trailParticles != null) {
            this.builder.trailParticles.accept(this);
        }
    }

    public void impactParticles(double v, double v1, double v2) {
        if (this.builder.impactParticles != null) {
            ImpactParticleContext context = new ImpactParticleContext(this, v, v1, v2);
            this.builder.impactParticles.accept(context);
        }
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    protected void doImpactSound(Holder<SoundEvent> sound) {
        super.doImpactSound(sound);
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        if (this.builder.setImpactSound != null) {
            return Optional.of(Holder.direct((Object)Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setImpactSound))));
        }
        return Optional.empty();
    }

    public void onAntiMagic(MagicData playerMagicData) {
        if (this.builder.onAntiMagic != null) {
            ISSKJSUtils.safeCallback(this.builder.onAntiMagic, new OnAntiMagicContext(playerMagicData, (Entity)this), "Error while calling onAntiMagic");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Damage", this.damage);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.damage = pCompound.getFloat("Damage");
    }

    public String entityName() {
        return this.getType().toString();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        super.shootFromRotation(pShooter, pX, pY, pZ, pVelocity, pInaccuracy);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.builder != null && this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((Entity)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHurt, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt."));
        }
        return super.hurt(pSource, pAmount);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder != null && this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lerpTo, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo."));
        }
    }

    public void tick() {
        super.tick();
        if (this.builder != null && this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.tick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: tick."));
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        if (this.builder != null && this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.move, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: move."));
        }
    }

    public void playerTouch(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.playerTouch, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch."));
        } else {
            super.playerTouch(player);
        }
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onRemovedFromWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld."));
        }
        super.onRemovedFromLevel();
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder != null && this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.thunderHit, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit."));
        }
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.builder != null && this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, pMultiplier, pFallDistance, pSource);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onFall, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall."));
        }
        return super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder != null && this.builder.onAddedToWorld != null && !this.level().isClientSide()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onAddedToWorld, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld."));
        }
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder != null && this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onSprint, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint."));
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder != null && this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onStopRiding, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding."));
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onRemovePassenger, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger."));
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder != null && this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.rideTick, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick."));
        }
    }

    public void onClientRemoval() {
        if (this.builder != null && this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onClientRemoval, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval."));
        }
        super.onClientRemoval();
    }

    public void lavaHurt() {
        if (this.builder != null && this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.lavaHurt, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt."));
        }
        super.lavaHurt();
    }

    protected void onFlap() {
        if (this.builder != null && this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onFlap, (Object)((Object)this), (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap."));
        }
        super.onFlap();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (this.builder != null && this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.shouldRenderAtSqrDistance(distance)));
        }
        return super.shouldRenderAtSqrDistance(distance);
    }

    public boolean isAttackable() {
        return this.builder.isAttackable != null ? this.builder.isAttackable.booleanValue() : super.isAttackable();
    }

    public boolean isPushable() {
        return true;
    }

    public void push(Entity pEntity) {
        if (this.builder.onEntityCollision != null) {
            ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext((Entity)this, pEntity);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onEntityCollision, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onEntityCollision."));
        }
        if (this.builder.isPushable) {
            super.push(pEntity);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.builder != null && this.builder.onHitEntity != null) {
            ContextUtils.ProjectileEntityHitContext context = new ContextUtils.ProjectileEntityHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHitEntity, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHitEntity."));
        } else {
            super.onHitEntity(result);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.builder != null && this.builder.onHitBlock != null) {
            ContextUtils.ProjectileBlockHitContext context = new ContextUtils.ProjectileBlockHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.onHitBlock, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: onHitBlock."));
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (this.builder != null && this.builder.canHitEntity != null) {
            Object obj = this.builder.canHitEntity.apply(entity);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return super.canHitEntity(entity) && b != false;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid canHitEntity for arrow builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.canHitEntity(entity)));
        }
        return super.canHitEntity(entity);
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity)));
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.getBlockJumpFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), (String)"float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor()));
        return super.getBlockJumpFactor();
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), (String)"float");
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply(this)) + ". Must be a float, defaulting to " + super.getBlockSpeedFactor()));
        return super.getBlockSpeedFactor();
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback((Consumer)this.builder.positionRider, (Object)context, (String)("[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider."));
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.canAddPassenger(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity)));
        return super.canAddPassenger(entity);
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping()));
        }
        return super.isFlapping();
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), (String)"float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply(this)) + ". Must be a float, defaulting to " + super.nextStep()));
        }
        return super.nextStep();
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze()));
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing()));
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null && !this.level().isClientSide()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing()));
        }
        return super.isCurrentlyGlowing();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations()));
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth()));
        }
        return super.showVehicleHealth();
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_)));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            Object obj = this.builder.canChangeDimensions.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from)));
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_)));
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance)));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance == null) {
            return super.getMaxFallDistance();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), (String)"integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce((String)("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply(this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance()));
        return super.getMaxFallDistance();
    }

    public static class ImpactParticleContext {
        public final SpellProjectileJS entity;
        public final double x;
        public final double y;
        public final double z;

        public ImpactParticleContext(SpellProjectileJS entity, double x, double y, double z) {
            this.entity = entity;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public record OnAntiMagicContext(MagicData getMagicData, Entity getEntity) {
    }
}

