/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.event;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CauldronRecipeEventJS
implements KubeEvent {
    private final List<CauldronRecipe> recipes = new ArrayList<CauldronRecipe>();

    public CauldronRecipe add(ItemStack output, ItemStack input, ItemStack ingredient) {
        CauldronRecipe recipe = new CauldronRecipe(input, ingredient, output);
        this.recipes.add(recipe);
        return recipe;
    }

    @HideFromJS
    public void registerAll() {
        this.recipes.forEach(CauldronRecipe::register);
    }

    public record CauldronRecipe(ItemStack input, ItemStack ingredient, ItemStack output, int inputCount, int outputCount) {
        public CauldronRecipe(ItemStack input, ItemStack ingredient, ItemStack output) {
            this(input, ingredient, output, 1, 4);
        }

        public CauldronRecipe {
            if (input.getCount() > 4) {
                ConsoleJS.STARTUP.warn((Object)("Cauldron input " + String.valueOf(input) + " with size over 4, setting max to 4."));
                input.setCount(4);
            }
            if (ingredient.getCount() != 1) {
                ConsoleJS.STARTUP.warn((Object)("Cauldron ingredient " + String.valueOf(ingredient) + " with size not equal to 1, setting to 1."));
                ingredient.setCount(1);
            }
            if (output.getCount() > 4) {
                ConsoleJS.STARTUP.warn((Object)("Cauldron output " + String.valueOf(output) + " with size over 4, setting max to 4."));
                output.setCount(1);
            }
            inputCount = input.getCount();
            outputCount = output.getCount();
            input.setCount(1);
            output.setCount(1);
        }

        public void register() {
            AlchemistCauldronRecipeRegistry.registerRecipe((ResourceLocation)this.output.kjs$getIdLocation(), (AlchemistCauldronRecipe)new AlchemistCauldronRecipe(this.input, this.ingredient, this.output).setBaseRequirement(this.inputCount).setResultLimit(this.outputCount));
        }
    }
}

