/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class CustomSpellBook
extends SpellBook {
    List<SpellData> spellData = new ArrayList<SpellData>();
    SpellDataRegistryHolder[] spellDataRegistryHolders;
    boolean unique;
    Holder<AbstractSpell> affinitySpell;

    public CustomSpellBook(Builder b) {
        super(b.maxSpellSlots, b.createItemProperties().stacksTo(1));
        this.spellDataRegistryHolders = b.spellHolders.toArray(new SpellDataRegistryHolder[0]);
        this.unique = b.unique;
        this.withSpellbookAttributes(b.defaultModifiers.toArray(new AttributeContainer[0]));
        this.affinitySpell = b.affinitySpell;
    }

    public boolean isUnique() {
        return this.unique;
    }

    private List<SpellData> getSpells() {
        if (this.spellDataRegistryHolders != null) {
            this.spellData.addAll(Arrays.stream(this.spellDataRegistryHolders).map(SpellDataRegistryHolder::getSpellData).toList());
            this.spellDataRegistryHolders = null;
        }
        return this.spellData;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ISpellContainer container;
        Object object;
        if (this.isUnique() && (object = stack.get((Supplier)ComponentRegistry.SPELL_CONTAINER)) instanceof ISpellContainer && (container = (ISpellContainer)object).isImproved()) {
            return Component.translatable((String)"tooltip.irons_spellbooks.improved_format", (Object[])new Object[]{super.getName(stack)});
        }
        return super.getName(stack);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)itemStack);
        AbstractSpell spell = affinityData.getSpell();
        if (spell != SpellRegistry.none()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.irons_spellbooks.spellbook_spell_count");
            lines.add(i < 0 ? lines.size() : i + 1, (Component)Component.translatable((String)"tooltip.irons_spellbooks.enhance_spell_level", (Object[])new Object[]{spell.getDisplayName(MinecraftInstanceHelper.instance.player()).withStyle(spell.getSchoolType().getDisplayName().getStyle())}).withStyle(ChatFormatting.YELLOW));
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (!ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            ISpellContainerMutable spellContainer = ISpellContainer.create((int)this.getMaxSpellSlots(), (boolean)true, (boolean)true).mutableCopy();
            List<SpellData> spells = this.getSpells();
            if (!spells.isEmpty()) {
                spells.forEach(spellSlot -> spellContainer.addSpell(spellSlot.getSpell(), spellSlot.getLevel(), true));
            }
            itemStack.set((Supplier)ComponentRegistry.SPELL_CONTAINER, (Object)spellContainer.toImmutable());
        }
        if (this.affinitySpell != null) {
            AffinityData.setAffinityData((ItemStack)itemStack, (AbstractSpell)((AbstractSpell)this.affinitySpell.value()));
        }
    }

    @ReturnsSelf
    public static class Builder
    extends ItemBuilder {
        public transient List<SpellDataRegistryHolder> spellHolders = new ArrayList<SpellDataRegistryHolder>();
        public transient int maxSpellSlots = 1;
        public transient List<AttributeContainer> defaultModifiers = new ArrayList<AttributeContainer>();
        public transient boolean unique = false;
        public transient Holder<AbstractSpell> affinitySpell;

        public Builder(ResourceLocation i) {
            super(i);
            this.tag(new ResourceLocation[]{ResourceLocation.parse((String)"curios:spellbook")});
        }

        @Info(value="Adds a default attribute to the item. Can be used multiple times.\nThe modifier operation can be either `ADD_MULTIPLIED_BASE`, `ADD_MULTIPLIED_TOTAL` or `ADD_VALUE`.\n")
        public Builder addAttribute(Holder<Attribute> attribute, double value, AttributeModifier.Operation operation) {
            this.defaultModifiers.add(new AttributeContainer(attribute, value, operation));
            return this;
        }

        @Info(value="Sets the maximum amount of spell slots the spell book can have.\n")
        public Builder setMaxSpellSlots(int maxSpellSlots) {
            this.maxSpellSlots = maxSpellSlots;
            return this;
        }

        @Info(value="Adds a default spell to the item. Can be used multiple times. It takes a spell ID (or a spell object) and the spell level.\nThis will turn into Unique Spellbook.\n")
        public Builder addSpell(Holder<AbstractSpell> spell, int spellLevel) {
            this.spellHolders.add(new SpellDataRegistryHolder(() -> spell.value(), spellLevel));
            return this;
        }

        @Info(value="Sets an affinity that will make this spell a +1 level boost.\n")
        public Builder setAffinitySpell(Holder<AbstractSpell> affinitySpell) {
            this.affinitySpell = affinitySpell;
            return this;
        }

        public SpellBook createObject() {
            this.maxSpellSlots = Math.max(this.spellHolders.size(), this.maxSpellSlots);
            if (!this.spellHolders.isEmpty()) {
                this.unique = true;
            }
            return new CustomSpellBook(this);
        }
    }
}

